 /*-----------------------------------------------------------------------------*
 * File Name: PagePreviewList.c		 											*
 * Creation: Frank	 7/25/05													*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Kevin 08/15/05 v8.0287 QA70-6323 FIX_REMOVE_SELECT_PAGE_BUG					*
 * Frank  11/11/05 ADD_ALL_OPEN_GRAPH_PAGE										*
 * Jasmine 11/25/05 QA70-8352 v8.0340 UPDATE_PROJECTBROWSEGRAPH					*
 * Jasmine 11/25/05 QA70-8352 v8.0340 OPEN_PAGE_PREVIEW_LIST_DLG				*
 * CPY 12/11/05 REMOVE_FO_CODE_FROM_PROJ_BROWER									*
 * Frank 12/19/05 SET_DEFAULT_WHEN_ADD_ALL_TO_EMPTY_LIST						*
 * Jasmine 06/22/06 NOT_ADD_MINIMIZED_GRAPH										*
 * Jasmine 07/12/06 ADD_CONTEXT_MENU											*
 * Jasmine 10/11/06 USE_SEPARATOR_IN_MERGE_GRAPH								*
 * Jasmine 10/24/06 REMBER_LAST_SELECTION										*
 * Jasmine 10/24/06 SHOW_DEFAULT_FOLDER_PAGE									* 
 * Jasmine 10/26/06 KEEP_DLG_MODEL												*
 * Jasmine 11/03/06 SHOULD_SHOW_SHORT_NAME										*
 * Jasmine 11/03/06 FIND_NODE_BY_ATTRBUTE_ONLY_FIND_CHILDREN					*
 * Jasmine 11/10/06 QA70-9112 GET_EMBEDDED_GRAPHS								*
 * Jasmine 11/17/06 SHOW_LNAME_AND_CELL											*
 * Jasmine 11/21/06 FIX_TREE_PANE_FAIL_TO_DISPLAY								*
 * Iris 12/12/2006 8.0523 TO_EXCLUDE_MULTI_PAGES								*
 * Jasmine 12/19/06 ADD_DBCLICK_ON_TREE_PANEL									*
 * Jasmine 01/22/07 UNCOMMENT_FOR_DRAG_AND_DROP_NOT_READY						*
 * Jasmine 01/22/07 ADD_EMBEDED_GRAPHS_IN_WKS									*
 * Jasmine 01/24/07 SAVE_EMBEDDED_CHECK_BOX_SETTING								*
 * Jasmine 01/23/07 IDENTIFY_LEVEL_BY_STOP_ATTRIB								*
 * Jasmine 02/06/07 DISABLE_OK_BUTTON_IF_NO_SELECTION							*
 * Joseph  02/14/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS				*
 * Jasmine 02/15/07 SHOW_NO_PREVIEW_IMAGE_IF_PAGE_INVALID						*
 * Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS										*
 * Folger 04/03/07 ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER							*
 * Folger 04/04/07 MODIFY_GRAG_AND_DROP_TO_GRAPH_BROWSER						*
 * Folger 04/05/07 MODIFY_GRAG_AND_DROP_TO_GRAPH_BROWSER_1						*
 * Folger 04/09/07 SHOW_EMBEDED_GRAPH_PATH										*
 * Folger 05/22/07 FIX_BUG_ON_SINGLE_SELECTION									*
 * Folger 05/29/07 ADD_BOOL_ENABLE_EMBED_IN_PAGE_PREVIEW_LIST_DLG				*
 * Folger 06/05/07 COMMENT_STR_EXCLUDE_PAGE										*
 * Jake   07/12/07 LOAD_NEW_IMAGE_FOR_NO_PREVIEW								*
 * Folger 07/18/07 SHOW_BOTH_GRAPH_AND_LAYOUT_IN_TREE_PANEL						*
 * Folger 07/18/07 CLEAN_UP_CONTROL_BITS_INTO_DWORD_FOR_GRAPH_BROWSER			*
 * Folger 07/19/07 CONTROL_BROWSE_PAGE_TYPE										* 
 * fisher 11/15/07 ADD_MAP_ID_TO_CHM											*
 * Folger 08/15/08 DISABLE_GRAPH_BROWSER_HELP									*
 * Iris 5/04/2009 QA80-13552 SUPPORT_OPTION_TO_SORT_PAGE_LIST_AND_FILTER_3D_PAGE*
 * Folger 06/19/09 QA80-13771 PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE*
 * Iris 6/26/2009 QA80-13771 TO_EXCLUDE_SPLINE_GRAPH_IN_LIST_VIEW				*
 * Iris 6/26/2009 WANT_SAVE_DOWNUP_BUTTON_STATE_IN_REGISTER						*
 * Iris 6/30/2009 FIX_SHOW_FRAME_IN_INCORRECT_PLACE_WHEN_OPEN_DLG_WITH_PREVIEW_PANEL_HIDDEN
 * Iris 7/13/2009 QA80-13771-P1 GBFM_MULTIPLE_PAGES_OPTIONS_DUPLICATE_WITH_3DOTS_GRAPHS_CONTROL
 * Iris 7/17/2009 QA80-13966-P2 NEED_DISABLE_OK_BUTTON_IF_SEL_FOLDER_IN_PEVIEW_OR_WORKBOOK
 * Kenny 07/17/2009 QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY	*
 * Iris 7/17/2009 QA80-13966-P3 SET_MULTI_SEL_OR_SINGLE_SEL_ON_stViewOptions	*
 * Army 08/03/09 FIX_LISTVIEW_AND_OKBUTTON_OVERLAP_IN_J_AND_G                   *
 * Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION			*
 * Jasmine 04/28/10 DLG_HAS_DIFF_SHAPE_AND_SAVE_DIFF_SIZE						*
 *------------------------------------------------------------------------------*/
#include <origin.h>
//#ifdef _FOR_SMART_LOADING_ONLY
//#endif //_FOR_SMART_LOADING_ONLY

////////////////////////////////////////////////////////////////////////////////////
#define  	_DMSG_MG(_str)  			//out_str(_str);  
#define 	STR_DLG_NAME 				"Graph Browser"//"Pick Graphs"//"Merge Graphs"
#define 	STR_DLG_NAME_S 				"Graphs Browser"	///Jasmine 04/28/10 DLG_HAS_DIFF_SHAPE_AND_SAVE_DIFF_SIZE
#define		STR_PAGE_LIST_SEPARATOR 	'\n'//'|'	///Jasmine 10/11/06 USE_SEPARATOR_IN_MERGE_GRAPH
#define		CHAR_FLD_SEPARATOR			'/'
#define		CHAR_FILENAME_SEPARATOR  	'"'

///Folger 04/03/07 ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER
//#define		COL_INDEX						0
#define		COL_INDEX					1
///End ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER

///Jasmine 02/15/07 SHOW_NO_PREVIEW_IMAGE_IF_PAGE_INVALID
#define STR_PREVIEW_GRAPH_TEMPLATE  okutil_get_origin_path(ORIGIN_PATH_SYSTEM, "Templates\Previews")

#define STR_PICT_NO_PREVIEW		"No Preview available"
///End SHOW_NO_PREVIEW_IMAGE_IF_PAGE_INVALID

///Folger 04/03/07 ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER
//enum{
	//COL_NAME,
	//COL_PATH
//};
enum{
	COL_NAME = 1,
	COL_PATH
};
///End ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER

///Jasmine 11/25/05 QA70-8352 v8.0340 UPDATE_PROJECTBROWSEGRAPH
//#define PROJECT_LIST_CLASS				PBPageList	///-----Frank 11/14/05 CHANGE_PROJECT_BROWSER_CLASS

//#include "ProjectBrowser.h"	
#include "DialogEx.h"

#include "../system/Page.h"			///Folger 04/09/07 SHOW_EMBEDED_GRAPH_PATH

#include <ocGDI.h>					///Jake 07/12/07 LOAD_NEW_IMAGE_FOR_NO_PREVIEW
//#include "fofunctprev.h"
#include <..\Originlab\GraphFilter.h> /// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT

///End UPDATE_PROJECTBROWSEGRAPH

///Jasmine 07/12/06 ADD_CONTEXT_MENU
enum{
	PROJECT_TR_ADD_ALL,
	PROJECT_TR_ADD_ALL_RECURSIVE,
	PROJECT_TR_ADD_ALL_OPEN,
	///Jasmine 11/17/06 SHOW_LNAME_AND_CELL
	PROJECT_TR_SEPARATOR,	
	PROJECT_TR_SHOW_LNAME,
	PROJECT_TR_SHOW_CELL,
	///End SHOW_LNAME_AND_CELL
	PROJECT_TR_ADD_LAST_ITEM
};

enum{
	SEL_LIST_REMOVE,
	SEL_LIST_UP,
	SEL_LIST_DOWN,
	//SEL_LIST_SHOW_FULL_PATH,
	
	SEL_LIST_LAST_ITEM
};

///------ Folger 06/19/09 QA80-13771 PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE
#define		STR_DIALOG_NAME			"PagePreviewListDlg"
#define		STR_LIST_SETTINGS			"Ssettings"
///------ End PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE

///Jasmine 04/28/10 DLG_HAS_DIFF_SHAPE_AND_SAVE_DIFF_SIZE
#define		PG_DLG_GAP					3
#define 	PG_DLG_MIN_SIZE				200
/////Army 08/03/09 FIX_LISTVIEW_AND_OKBUTTON_OVERLAP_IN_J_AND_G
////#define		MIN_MAIN_DLG_WIDTH		350  /// Iris 6/30/2009 SET_DLG_MIN_WIDTH
//#define		MIN_MAIN_DLG_WIDTH_E		385
//#define		MIN_MAIN_DLG_WIDTH_J		450
//#define		MIN_MAIN_DLG_WIDTH_G		430
/////End FIX_LISTVIEW_AND_OKBUTTON_OVERLAB_IN_J_AND_G
///End DLG_HAS_DIFF_SHAPE_AND_SAVE_DIFF_SIZE

class ProjectTreeMenu : public Menu
{
public:
	///Jasmine 11/17/06 SHOW_LNAME_AND_CELL		
	/// Kenny 09/08/2009 IMPROVE_SHOW_HIDE_CONTEXT_MENU
	//ProjectTreeMenu(bool bFolder, bool bMulti, bool bLName = false, bool bEmbed = false, bool bCell = false)
	ProjectTreeMenu(bool bFolder, bool bMulti, bool bLName = false, bool bEmbed = false, bool bCell = false, bool bAddingItems = true)
	/// End IMPROVE_SHOW_HIDE_CONTEXT_MENU
	{
		m_nChoice = -1;
		/// Kenny 09/08/2009 IMPROVE_SHOW_HIDE_CONTEXT_MENU
		m_nBaseIndex = bAddingItems ? PROJECT_TR_ADD_ALL : PROJECT_TR_SHOW_LNAME;
		if ( bAddingItems )
		/// End IMPROVE_SHOW_HIDE_CONTEXT_MENU
		{
			Add(_L("Add"), OnMenuItem);
			Add(_L("Add ALL( Recursive)"), OnMenuItem, (bFolder && !bMulti)? MF_ENABLED : MF_DISABLED | MF_GRAYED);
			Add(_L("Add ALL Open"), OnMenuItem, (bFolder && !bMulti)? MF_ENABLED : MF_DISABLED | MF_GRAYED);
			Add(NULL, EmptySepFunc, MF_SEPARATOR);
		}
		Add(_L("Show Long Name"), OnMenuItem,  MF_STRING | (bLName ? MF_CHECKED: MF_UNCHECKED));
		Add(_L("Show Cell Location"), OnMenuItem,  MF_STRING | (bCell ? MF_CHECKED: MF_UNCHECKED) | (bEmbed ? MF_ENABLED : MF_DISABLED | MF_GRAYED));
	///End SHOW_LNAME_AND_CELL
	}
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	bool GetCommand(int& nChoice)
	{
		if(m_nChoice >= PROJECT_TR_ADD_ALL && m_nChoice <= PROJECT_TR_ADD_LAST_ITEM)
		{
			nChoice = m_nChoice;
			nChoice += m_nBaseIndex;	/// Kenny 09/08/2009 IMPROVE_SHOW_HIDE_CONTEXT_MENU
			return true;
		}
		return false;
	}
	void EmptySepFunc(uint nCmd)
	{
	}
private:
	int	m_nChoice;
	int m_nBaseIndex;	/// Kenny 09/08/2009 IMPROVE_SHOW_HIDE_CONTEXT_MENU
};

class SelListMenu : public Menu
{
public:
	SelListMenu(bool bMulti, bool bFullPath = true)
	{
		m_nChoice = -1;
		Add(_L("Remove"), OnMenuItem);
		Add(_L("Up"), OnMenuItem, !bMulti? MF_ENABLED : MF_DISABLED | MF_GRAYED);
		Add(_L("Down"), OnMenuItem, !bMulti? MF_ENABLED : MF_DISABLED | MF_GRAYED);
		//Add(_L("Show Full Path"), OnMenuItem, bFullPath? MF_CHECKED : MF_UNCHECKED);
		
	}
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	bool GetCommand(int& nChoice)
	{
		if(m_nChoice >= SEL_LIST_REMOVE && m_nChoice <= SEL_LIST_LAST_ITEM)
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
private:
	int	m_nChoice;
};
///End ADD_CONTEXT_MENU

/// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_MODE
#define STR_DISPLAY_NAME_ATTRB		"DisplayName"
static string _get_embedded_graph_cell_location(LPCSTR lpcszPage)
{	
	Worksheet 	wks;
	int 		nRow, nCol;
	string 		strLocation;
	Page 		pg(lpcszPage);
	if( pg && pg.GetEmbeddingInfo(wks, &nRow, &nCol) )
	{
		strLocation.Format("[%s]%s!%d[%d:%d]", wks.GetPage().GetName(), wks.GetName(), nCol, nRow, nRow );		
	}	
	return strLocation;
}

enum
{
	VIEW_MODE_LIST = 0,
	VIEW_MODE_PE
};

struct PageViewOptions
{
	int 		nPageType;	
	bool		bMultiplePages;	//dialog support select multiple page as result	
	
	bool 		bShowFolders;
	string 		strStartPEPath;
	
	bool 		bLongNameShow;
	bool		bCellShow; 
	
	string		strFilterFuncName;	
	int			nViewMode;
	
	bool		bEmbedControlEnable;
	bool		bViewModeControlShow;
	
	ProjectTreeOptions	stProjectTreeOptions;
};

/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
typedef int (*FUNC_GRAPH_FILTER_FUNC)(int nMsg, Page& pg = NULL);

static FUNC_GRAPH_FILTER_FUNC _get_filter_func_pointer(LPCSTR lpcszFilterFuncName)
{
	FUNC_GRAPH_FILTER_FUNC pFunc = Project.FindCompiledFunction(lpcszFilterFuncName);
	if( NULL == pFunc )
	{
		//error_report("Fail to find graph filter function");
		return NULL;
	}	
	return pFunc;
}

static bool _get_page_view_options_by_filter_func(PageViewOptions& stViewOptions)
{
	FUNC_GRAPH_FILTER_FUNC pFunc = _get_filter_func_pointer(stViewOptions.strFilterFuncName);
	if( !pFunc )
		return false;
	
	int nRet = 0;
	
	// embedded checkbox show/hide control and embedded graphs show/hide control
	nRet = pFunc(GBFM_SHOW_EMBED_PAGE_CHKBOX);
	if( nRet >= 0 ) // < 0 means no this option in filter function
	{
		switch( nRet )
		{
		case EMBED_CHECKBOX_ENABLE:
			stViewOptions.bEmbedControlEnable = true;
			stViewOptions.stProjectTreeOptions.bGetEmbeddedGraph = true; //default is checked
			break;
		case EMBED_CHECKBOX_DISABLE_EMBEDDING_PAGE_NEVER_ENABLE:
			stViewOptions.bEmbedControlEnable = false;
			stViewOptions.stProjectTreeOptions.bGetEmbeddedGraph = false;
			break;
		case EMBED_CHECKBOX_DISABLE_EMBEDDING_PAGE_ALWAYS_ENABLE:
			stViewOptions.bEmbedControlEnable = false;
			stViewOptions.stProjectTreeOptions.bGetEmbeddedGraph = true;
			break;	
		default:
			ASSERT(0); // other case need more code support...
			break;
		}
	}
	
	// view mode checkbox show/hide control and view mode control
	nRet = pFunc(GBFM_SHOW_SWITCH_MODE);
	if( nRet >= 0 ) // < 0 means no this option in filter function
	{
		switch( nRet )
		{
		case VIEW_MODE_TREE_ONLY:
			stViewOptions.bViewModeControlShow = false;
			stViewOptions.nViewMode = VIEW_MODE_PE;
			break;
		case VIEW_MODE_LIST_ONLY:
			stViewOptions.bViewModeControlShow = false;
			stViewOptions.nViewMode = VIEW_MODE_LIST;
			break;
		case VIEW_MODE_BOTH_WITH_GLOBAL_DEFAULT:
			ASSERT(0); // to do 
			break;
		case VIEW_MODE_BOTH_WITH_LIST_DEFAULT:
			stViewOptions.bViewModeControlShow = true;
			stViewOptions.nViewMode = VIEW_MODE_LIST;			
			break;
		case VIEW_MODE_BOTH_WITH_TREE_DEFAULT:
			stViewOptions.bViewModeControlShow = true;
			stViewOptions.nViewMode = VIEW_MODE_PE;			
			break;
		default:
			ASSERT(0);  // other case need more code support...
			break;
		}		
	}
	
	/// Iris 7/13/2009 QA80-13771-P1 GBFM_MULTIPLE_PAGES_OPTIONS_DUPLICATE_WITH_3DOTS_GRAPHS_CONTROL
	//nRet = pFunc(GBFM_MULTIPLE_PAGES);
	//if( nRet >= 0 )
	//{
		//stViewOptions.bMultiplePages = 0 == nRet? false : true;
	//}
	///end GBFM_MULTIPLE_PAGES_OPTIONS_DUPLICATE_WITH_3DOTS_GRAPHS_CONTROL
	
	nRet = pFunc(GBFM_SORT_PAGES);
	if( nRet >= 0 )
	{
		stViewOptions.stProjectTreeOptions.bSortPages = 1 == nRet? true : false;
	}
	
	return true;
}

static bool _filter_page_by_filter_func(LPCSTR lpcszFilterFuncName, const Page& pg)
{
	if( !pg )
		return true; // if page is invalid, filter it
	
	FUNC_GRAPH_FILTER_FUNC pFunc = _get_filter_func_pointer(lpcszFilterFuncName);
	if( !pFunc )
		return false; // fail to find function means no need filter
	
	if( pFunc(GBFM_IS_USE_PAGE, pg) > 0 )
		return false;	
	return true; // true mean filter this page
}
///end FILTER_GRAPH_FUNCTION_SUPPORT

enum
{
	LIST_SHORT_NAME_COL,
	LIST_LONG_NAME_COL,
	LIST_CELL_LOCATION_COL,
	
	LIST_COL_COUNT //keep it last one
};

class PageListView : public TreeEditControl
{
public:		
	void InitControl(WndContainer& dlg, const PageViewOptions& stViewOptions, LPCSTR lpcszPage = "")
	{		
		Init(IDC_FOLDER_TREE, dlg);
		
		SetReady(false);	
		SetSelection(flexSelectionByRow);
		///Iris 7/17/2009 QA80-13966-P3 SET_MULTI_SEL_OR_SINGLE_SEL_ON_stViewOptions
		//SetAllowSelection(true);
		SetAllowSelection(stViewOptions.bMultiplePages);
		///end SET_MULTI_SEL_OR_SINGLE_SEL_ON_stViewOptions
		SetEditable();
		SetTreeView(false);
		
		setupColHeader(stViewOptions.stProjectTreeOptions.bGetEmbeddedGraph);		
		updatePageView(stViewOptions, lpcszPage);
		
		///------ Folger 06/19/09 QA80-13771 PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE
		vector<byte>		vbHideCols = {0, 0, 0};
		vbHideCols[LIST_LONG_NAME_COL] = !stViewOptions.bLongNameShow;
		vbHideCols[LIST_CELL_LOCATION_COL] = !stViewOptions.bCellShow;
		SetHiddenCols(vbHideCols);
		///------ End PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE
		
		SetReady(true);		
	}
	
	bool setupColHeader(bool bGetEmbeddedGraph)
	{
		vector<string> 		vsColHeaders;
		vsColHeaders.Add( _L("Short Name") );
		vsColHeaders.Add( _L("Long Name") );		
		if( bGetEmbeddedGraph )
			vsColHeaders.Add( _L("Cell Location") );
		
		// set the size of rows and columns		
		SetupRowsCols(1, 0,  1, vsColHeaders.GetSize());
		
		m_flx.ExplorerBar = flexExSortShow;		///------ Folger 06/19/09 QA80-13771 PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE
		
		// setup column header
		for( int ii = 0; ii < vsColHeaders.GetSize(); ii++ )
		{
			SetColHeading(ii, vsColHeaders[ii]);
		}
		return true;
	}
	
	void UpdatePageView(const PageViewOptions& stViewOptions)
	{
		SetReady(false);
		
		setupColHeader(stViewOptions.stProjectTreeOptions.bGetEmbeddedGraph); // need remove Cell Location column if Show Embedded Graph is unchecked
		updatePageView(stViewOptions);
		
		SetReady(true);
	}	
	
	int GetSelectedPages(vector<string>& vsPages, bool bRecursive = false, vector<int>* pvDisplayID = NULL)
	{
		vsPages.RemoveAll();
		
		vector<uint> 	vnSelRows;
		GetSelRows(vnSelRows);		
		if(vnSelRows.GetSize() < 1)
			return 0;		

		for(int ii = 0; ii < vnSelRows.GetSize(); ii++)
		{
			vsPages.Add( GetCell(vnSelRows[ii], LIST_SHORT_NAME_COL) );
		}
			
		return vsPages.GetSize();		
	}

	///------ Folger 06/19/09 QA80-13771 PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE
	BOOL	CheckShowContextMenu(int nx, int ny)
	{
		int		nRow, nCol;
		GetMouseCell(nRow, nCol);
		if ( 0 != nRow )
			return FALSE;

		vector<byte>	vbHide;
		GetHiddenCols(vbHide);
		
		vector<string>	vsColHeading;
		GetRowValues(0, vsColHeading);

		vector<bool>	vbDisabled(vbHide.GetSize());
		vbDisabled[0] = 1;
		
		CheckMenu		menu(!vbHide, vsColHeading, vbDisabled);
		int nCmd = menu.DoTrackPopup(nx, ny, GetDlgSafeHwnd());
		if ( nCmd < 0 )
			return FALSE;

		/// we assume that nCmd is exactly match column hedaers with 0 offset
		if ( nCmd >= vbHide.GetSize() )
		{
			ASSERT(false);
			return FALSE;
		}

		vbHide[nCmd] = !vbHide[nCmd];
		SetHiddenCols(vbHide);

		return TRUE;
	}
	///------ End PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE

private:
	void updatePageView(const PageViewOptions& stViewOptions, LPCSTR lpcszPage = "")
	{		
		ClearAll();		

		// get the specified folder by options
		Folder fld = Project.RootFolder;		
		if( !stViewOptions.bShowFolders )
		{		
			Folder fldStart(stViewOptions.strStartPEPath);
			if( fldStart )
				fld = fldStart;
		}
		
		// get graph pages from specified folder
		vector<string> vsGraphs;
		get_folder_pages_name(fld, vsGraphs, EXIST_PLOT, true);			
		
	 	// filter pages by filter function
		vector<string> vsNames, vsLongNames, vsCells;
		for(int ii = 0; ii < vsGraphs.GetSize(); ii++)
		{
			Page pg( vsGraphs[ii] );
			if( !_filter_page_by_filter_func(stViewOptions.strFilterFuncName, pg) && stViewOptions.nPageType == pg.GetType() )
			{
				vsNames.Add( pg.GetName() );
				vsLongNames.Add( pg.GetLongName() );
				vsCells.Add( "" );
			}
		}
			
		// add graph pages that embedded in worksheet
		if( stViewOptions.stProjectTreeOptions.bGetEmbeddedGraph )
		{
			vector<string> vsWks;
			get_folder_pages_name(fld, vsWks, EXIST_WKS, true);
			
			for(ii = 0; ii < vsWks.GetSize(); ii++)
			{
				WorksheetPage wksPage( vsWks[ii] );
				ASSERT( wksPage );
				
				if( wksPage )
				{
					foreach(Layer lay in wksPage.Layers)
					{
						Worksheet wks(lay);
						ASSERT(wks);						
						
						/// Iris 6/26/2009 QA80-13771 TO_EXCLUDE_SPLINE_GRAPH_IN_LIST_VIEW
						//foreach( Page gp in wks.EmbeddedPages )
						//{
						vector<string> vsEmbededs;
						wks.GetEmbeddedGraphs(vsEmbededs, GRAPH_IN_WKS_EXCLUDE_BITS);
						for( int nn = 0; nn < vsEmbededs.GetSize(); nn++ )
						{
							GraphPage gp(vsEmbededs[nn]);
						///end TO_EXCLUDE_SPLINE_GRAPH_IN_LIST_VIEW
							if( _filter_page_by_filter_func(stViewOptions.strFilterFuncName, gp) || stViewOptions.nPageType != gp.GetType())
								continue;
							
							vsNames.Add( gp.GetName() );
							vsLongNames.Add( gp.GetLongName() );
							vsCells.Add(  _get_embedded_graph_cell_location( gp.GetName() ) );
						}
						

					}
				}
			}
		}
		
		// sort pages if needed
		if( stViewOptions.stProjectTreeOptions.bSortPages )
		{
			vector<uint> 	vnIndeces;
			vsNames.Sort(SORT_ASCENDING, true, vnIndeces);
			
			vsLongNames.Reorder( vnIndeces );
			vsCells.Reorder( vnIndeces );
			
		}

		int nSelRow = GetSelectedRow();
		SetColValues(LIST_SHORT_NAME_COL, vsNames, 0, true);
		SetColValues(LIST_LONG_NAME_COL, vsLongNames, 0, true);		
		SetColValues(LIST_CELL_LOCATION_COL, vsCells, 0, true);
		if( -1 == nSelRow && lpcszPage && 0 != lstrlen(lpcszPage) )		
		{
			nSelRow = vsNames.Find(lpcszPage) + 1; // add 1 since the first row is column header			
		}
		SelRow(nSelRow);

		ResizeCols();
	}
};

class PEView : public GridTreeControl
{
public:		
	void InitControl(WndContainer& dlg, const PageViewOptions& stViewOptions, LPCSTR lpcszPage = "")
	{		
		Init(IDC_FOLDER_TREE, dlg);	

		SetSelection(flexSelectionListBox);
		SetAllowSelection(stViewOptions.bMultiplePages);
			
		updatePageView(stViewOptions, lpcszPage);	
	}	
	
	string GetFullPathFromPageName(LPCSTR lpcszPage)
	{
		PageBase pg = Project.Pages(lpcszPage);
		if( !pg )
			return "";
		
		string 	strPath;
		TreeNode tr = m_tree.FindNodeByAttribute(STR_LABEL_ATTRIB, lpcszPage);		
		if(tr)
			tr.GetAttribute(STR_PATH_ATTRIB, strPath);
		return strPath;		
	}
	
	void UpdatePageView(const PageViewOptions& stViewOptions)
	{
		updatePageView(stViewOptions);
	}
	
	/// Iris 7/17/2009 QA80-13966-P2 NEED_DISABLE_OK_BUTTON_IF_SEL_FOLDER_IN_PEVIEW_OR_WORKBOOK
	// to check selected row, return true if is specified page type ( == stViewOptions.nPageType), else return false.
	bool IsSpecifiedPageTypeSelected(int nPageType)
	{
		if( IsFolderSelected() ) // if selected folder or workbook including embedded pages
			return false;		
		
		int nSel = GetSelectedRow(); 
		if( nSel < 0 ) // no selection
			return false;
		
		TreeNode tr = tree_get_node(m_tree, nSel);
		if(tr.IsValid())
		{
			int 	nDisplay = -1;
			if( tr.GetAttribute(STR_DISPLAY_ATTRIB, nDisplay) && nDisplay == get_page_display_id(nPageType) )
				return true;				
		}
		
		return false;		
	}
	///end NEED_DISABLE_OK_BUTTON_IF_SEL_FOLDER_IN_PEVIEW_OR_WORKBOOK
	
	bool IsFolderSelected(bool* pbMulti = NULL)
	{
		bool bFolder = false, bMulti = false;
		vector<uint> vnSelRows;
		GetSelRows(vnSelRows);
	
		int nClickRow, nClickCol;
		GetMouseCell(nClickRow, nClickCol);
		if(0 <= nClickRow)
		{
			vector<uint> vecIndex;
			vnSelRows.Find(vecIndex, nClickRow);
			if(!vecIndex.GetSize())
			{
				SelRow(nClickRow);
				bMulti = false;
			}
			else
			{
				nClickRow = vnSelRows[0];
				/// Kenny 09/08/2009 IMPROVE_SHOW_HIDE_CONTEXT_MENU
				bMulti = vnSelRows.GetSize() > 1;
				/// End IMPROVE_SHOW_HIDE_CONTEXT_MENU
			}
		}
		
		TreeNode tr = tree_get_node(m_tree, nClickRow);
		if(tr.IsValid())
			bFolder = tr.GetNodeCount() > 0;
		
		if( pbMulti )
			*pbMulti = bMulti;
		return bFolder;
	}
	
	int GetSelectedPages(vector<string>& vsPages, bool bRecursive = false, vector<int>* pvDisplayID = NULL)
	{
		vsPages.RemoveAll();
		
		vector<uint> 	vnSelRows;
		GetSelRows(vnSelRows);		
		if(vnSelRows.GetSize() < 1)
			return 0;
		
		vector<int> 	vnDisplayIDs;
		for(int ii = 0; ii < vnSelRows.GetSize(); ii++)
		{
			int 		nSelRow = vnSelRows[ii];
			TreeNode 	trSel = tree_get_node(m_tree, nSelRow);
			
			vector<string> 	vs;
			vector<int>		vn;
			getGraphsInProjectTree(trSel, vs, vn, bRecursive);
			for(int nn = 0; nn < vs.GetSize(); nn++)
			{
				if(vsPages.Find(vs[nn]) < 0) 				
				{
					vsPages.Add(vs[nn]);
					vnDisplayIDs.Add(vn[nn]);
				}
			}
		}	
		if(NULL != pvDisplayID)
			*pvDisplayID = vnDisplayIDs;
	
		return vsPages.GetSize();
	}	
	
	void ShowMoreInfo(bool bLongName = false, bool bCell = false)
	{
		for(int nRow = 0; ; nRow++)
		{
			TreeNode trRow = tree_get_node(m_tree, nRow);
			if(!trRow.IsValid())
				break;
			
			int nDisplay, nLevel;
			trRow.GetAttribute(STR_DISPLAY_ATTRIB, nDisplay);
			trRow.GetAttribute(STR_STOP_ATTRIB, nLevel);
			if(PTL_PAGE != nLevel)//LName is for page only
				continue;
			
			string strLabel, strSName, strCell;
			trRow.GetAttribute(STR_LABEL_ATTRIB, strSName);
			strLabel = strSName;
			
			if(bLongName)
			{
				string strLName;
				trRow.GetAttribute(STR_NAME_ATTRIB, strLName);
				strLabel += " - "+ strLName;
			}
			
			if(bCell && nDisplay == IDR_GRAPHTYPE_V8)//bCell is for Embedded GraphPage only
			{
				string str = _get_embedded_graph_cell_location(strSName);
				if( !str.IsEmpty() )
				{
					strLabel += " - " + str;
				}
			}
			
			trRow.SetAttribute(STR_DISPLAY_NAME_ATTRB, strLabel);
			SetCell(nRow, 0, strLabel);
		}
	}
	
private:	
	void updatePageView(const PageViewOptions& stViewOptions, LPCSTR lpcszPage = "")
	{
		ClearAll();
		m_tree.Reset();
		
		string 		strStartPEpathTemp = stViewOptions.bShowFolders? "" : stViewOptions.strStartPEPath;
		/// Iris 5/04/2009 QA80-13552 SUPPORT_OPTION_TO_SORT_PAGE_LIST_AND_FILTER_3D_PAGE
		ProjectTreeOptions stTempOptions;
		stTempOptions = stViewOptions.stProjectTreeOptions;
		
		/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT			
		Folder fld = Project.RootFolder;
		if(!strStartPEpathTemp.IsEmpty())
		{
			Folder rtFolder(strStartPEpathTemp);
			if( rtFolder.IsValid() )
				fld.Attach(strStartPEpathTemp);
		}
		
		vector<string> 	vsGraphs;
		get_folder_pages_name(fld, vsGraphs, EXIST_PLOT, true);
		
		if( stTempOptions.bGetEmbeddedGraph )
		{
			vector<string> vsEmbeddedGraphs;
			get_folder_embedded_graphs(fld, vsEmbeddedGraphs, true);
			vsGraphs.Append(vsEmbeddedGraphs);
		}		
				
		vector<string>	vsFilterPages;
		for(int nn = 0; nn < vsGraphs.GetSize(); nn++)
		{
			Page pg( vsGraphs[nn] );
			if( !pg || pg && _filter_page_by_filter_func(stViewOptions.strFilterFuncName, pg) )
				vsFilterPages.Add( vsGraphs[nn] );
		}		
		if( 0 != vsFilterPages.GetSize() )
			stTempOptions.vsExcludePages = vsFilterPages;
		///end FILTER_GRAPH_FUNCTION_SUPPORT
		
		bool flag = get_project_tree(m_tree, PTL_PAGE, stViewOptions.nPageType, 0, strStartPEpathTemp, stTempOptions);
		///end SUPPORT_OPTION_TO_SORT_PAGE_LIST_AND_FILTER_3D_PAGE		

		flag = AddTreeNodes(m_tree, ATRN_LOOP_MARDED_NODE_ONLY, STR_DISPLAY_ATTRIB);
		ShowMoreInfo(stViewOptions.bLongNameShow, stViewOptions.bCellShow);
		
		int nRow;
		if(stViewOptions.bShowFolders)
		{
			TreeNode tr = m_tree;
			string str;
			m_tree.GetAttribute(STR_PATH_ATTRIB, str);
			if(stViewOptions.strStartPEPath.CompareNoCase(str))
				tr = m_tree.FindNodeByAttribute(STR_PATH_ATTRIB, stViewOptions.strStartPEPath);
			
			for( ; tr.FirstNode.IsValid(); tr = tr.FirstNode)
				;
			string strLabel;
			if(tr.IsValid())
				tr.GetAttribute(STR_DISPLAY_NAME_ATTRB, strLabel);
			nRow = FindRow(strLabel);
		}
		
		//select row by page name since switch PE view with List view need to keep current page selection
		if( lpcszPage && 0 != lstrlen(lpcszPage) ) 
		{
			TreeNode 	tr = m_tree.FindNodeByAttribute(STR_LABEL_ATTRIB, lpcszPage);
			string 		strLabel;
			if(tr)
				tr.GetAttribute(STR_DISPLAY_NAME_ATTRB, strLabel);
			nRow = FindRow(strLabel);
		}
		
		SelRow(nRow);	
	}

	bool getGraphsInProjectTree(TreeNode tr, vector<string>& vsPages, vector<int>& vnDisplayIDs, bool bRecursive = false)
	{
		if(!tr.IsValid())
			return false;
		
		int nLevel;
		if(tr.GetNodeCount() < 1 && tr.GetAttribute(STR_STOP_ATTRIB, nLevel) && PTL_FOLDER < nLevel)//leaf
		{
			string 	strName;
			tr.GetAttribute(STR_LABEL_ATTRIB, strName);			
			
			/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
			vsPages.Add(strName);
			int 	nDisplay = -1;
			tr.GetAttribute(STR_DISPLAY_ATTRIB, nDisplay);
			vnDisplayIDs.Add(nDisplay);	
			/*
			Page pg(strName);
			if( pg && !_filter_page_by_filter_func(m_strFilterFuncName, pg) )
			{		
				vsPages.Add(strName);
				
				int 	nDisplay = -1;
				tr.GetAttribute(STR_DISPLAY_ATTRIB, nDisplay);
				vnDisplayIDs.Add(nDisplay);	
			}
			*/
			///end FILTER_GRAPH_FUNCTION_SUPPORT
		}
		
		foreach(TreeNode cNode in tr.Children)
		{
			bool bRecusiveSubNode = bRecursive;
			
			int nDisplay;
			if(cNode.GetAttribute(STR_DISPLAY_ATTRIB, nDisplay) && 
				( nDisplay == get_page_display_id(EXIST_WKS) ||
				nDisplay == get_layer_display_id(EXIST_WKS) )
				)//only check workbook
				bRecusiveSubNode = true;
			
			if(!cNode.IsValid() || (cNode.GetNodeCount() && !bRecusiveSubNode) )
				continue;
			
			getGraphsInProjectTree(cNode, vsPages, vnDisplayIDs, bRecusiveSubNode);
		}
		return true;
	}

	
private:
	Tree				m_tree;
	string				m_strFilterFuncName;
};

class PageViewManager
{
public:
	PageViewManager()
	{
		m_nMode = -1;
	}
	
	///------ Folger 06/19/09 QA80-13771 PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE
	~PageViewManager()
	{
		if ( NULL != m_pPEView )
			delete m_pPEView;
		else if ( NULL != m_pListView )
			delete m_pListView;
	}
	///------ End PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE
	
	void SetReady()
	{
		if( m_pPEView )
			m_pPEView->SetReady();
		if( m_pListView )
			m_pListView->SetReady();
	}
	
	void SetViewMode(int nMode)
	{
		if( m_pPEView || m_pListView )
			m_strSelectedPage = GetSelectedPage(); // remeber the curremt page selection before mode change
		if(m_nMode == nMode)
			return;
		m_nMode = nMode;
	}
	
	int GetViewMode()
	{
		return m_nMode;
	}
	void SetEmbeddedShow(bool bShow = true)
	{
		m_stViewOptions.stProjectTreeOptions.bGetEmbeddedGraph = bShow;
	}
	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	void SetIncludeShortcut(bool bShow = true)
	{
		DWORD dwTemp = m_stViewOptions.stProjectTreeOptions.dwCtrl | PT_CTRL_INCLUDE_SHORTCUT;
		if(!bShow)
			dwTemp &= ~PT_CTRL_INCLUDE_SHORTCUT;
		m_stViewOptions.stProjectTreeOptions.dwCtrl = dwTemp;
	}
	///End BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	void UpdatePageView()
	{
		if( VIEW_MODE_LIST == m_nMode )
		{
			ASSERT(m_pListView);
			m_pListView->UpdatePageView(m_stViewOptions);
		}
		else
		{
			ASSERT(m_pPEView);
			m_pPEView->UpdatePageView(m_stViewOptions);
		}
	}
	
	void InitControl(WndContainer& dlg, PageViewOptions& stViewOptions)
	{
		m_stViewOptions = stViewOptions;
		
		if( VIEW_MODE_PE == m_nMode )
		{
			if( m_pPEView )
				return;
			
				if( m_pListView )
				{					
					delete m_pListView;
					m_pListView = NULL;
				}
			
			m_pPEView = new PEView;
			if(m_pPEView)
			{
				m_pPEView->InitControl(dlg, stViewOptions, m_strSelectedPage);	
			}
		}
		
		if( VIEW_MODE_LIST == m_nMode )
		{
			if( m_pListView )
				return;
			
				if( m_pPEView )
				{					
					delete m_pPEView;
					m_pPEView = NULL;
				}

			m_pListView = new PageListView;
			if(m_pListView)
			{
				m_pListView->InitControl(dlg, stViewOptions, m_strSelectedPage);
			}	
		}	
	}
	
	string GetSelectedPage()
	{
		vector<string> vs;
		if( GetSelectedPages(vs) <= 0 )
			return "";
		return vs[0]; //return the first selected
	}
	
	int	GetSelectedPages(vector<string>& vsPages, bool bRecursive = false, vector<int>* pvDisplayID = NULL)
	{
		if( VIEW_MODE_LIST == m_nMode )
		{
			ASSERT(m_pListView);
			return m_pListView->GetSelectedPages(vsPages, bRecursive, pvDisplayID);
		}
		else
		{
			ASSERT(m_pPEView);
			return m_pPEView->GetSelectedPages(vsPages, bRecursive, pvDisplayID);
		}
	}
	
	PEView* 	GetPEViewPointer()
	{
		//ASSERT(m_pPEView);
		return m_pPEView;
	}
	
	PageListView*	GetListViewPointer()
	{
		//ASSERT(m_pListView);
		return m_pListView;
	}

private:
	int				m_nMode;
	string			m_strSelectedPage;
	PEView*			m_pPEView;
	PageListView*	m_pListView;
	PageViewOptions m_stViewOptions;
};
///end ADD_LIST_VIEW_MODE

///------ Folger 06/19/09 QA80-13771 PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE
enum
{
	LIST_SETTING_SHOW_LN			= 0,
	LIST_SETTING_SHOW_CELL_INFO,

	LIST_SETTING_TOTAL,
};
///------ End PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE

class PagePreviewListDlg : public MultiPaneDlg
{	
public:	
	/// Iris 8/23/06 QA80-7729 GRAPH_BRWOSER_BUTTON_IN_GETN
	/////Jasmine 11/25/05 QA70-8352 v8.0340 OPEN_PAGE_PREVIEW_LIST_DLG
	////PagePreviewListDlg(LPCSTR strTitle, const vector<int>& nPageTypes, int nSelectedMode = MULTIPLE_SELECT) : MultiPaneDlg(IDD_MG_DLG, "ODlg8")
	//PagePreviewListDlg(LPCSTR strExclude, const vector<int>& nPageTypes, vector<string>& vsPages = NULL) : MultiPaneDlg(IDD_PG_DLG, "ODlg8")//IDD_MG_DLG
	//------Folger 07/18/07 CLEAN_UP_CONTROL_BITS_INTO_DWORD_FOR_GRAPH_BROWSER
	//PagePreviewListDlg(const vector<int>& nPageTypes, LPCSTR lpcszPages = NULL, 
			//bool	bMultiplePages = true,
			//LPCSTR  lpcszTitle = NULL, 
			//LPCSTR  lpcszStartPEpath = NULL, //if bShowFolders is true, then activise this folder; false, then just show this folder
			//bool    bShowFolders = true, //if bShowFolders = false, then only pick from specified folder, if true, then can switch to other folders
			////LPCSTR  lpcszExclude = NULL, // exclude the specified folder		///Folger 06/05/07 COMMENT_STR_EXCLUDE_PAGE
			//bool	bEnableEmbed = true		///Folger 05/29/07 ADD_BOOL_ENABLE_EMBED_IN_PAGE_PREVIEW_LIST_DLG
			//) : MultiPaneDlg(IDD_PG_DLG, "ODlg8", !bMultiplePages)///Jasmine 11/17/06 SHOW_LNAME_AND_CELL, set preview on the side if select single page			
	PagePreviewListDlg(const vector<int>& nPageTypes, LPCSTR lpcszPages = NULL, 
			LPCSTR  lpcszTitle = NULL, 
			LPCSTR  lpcszStartPEpath = NULL, //if bShowFolders is true, then activise this folder; false, then just show this folder
			DWORD dwCtrl = SELECT_MULTIPLE_PAGES | SHOW_FOLDERS | ENABLE_EMBEDED,
			int nPageType = EXIST_GRAPH,		//-------Folger 07/19/07 CONTROL_BROWSE_PAGE_TYPE
			/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
			//int nViewMode = VIEW_MODE_PE,	/// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_CHECKBOX
			LPCSTR lpcszFilterFuncName = NULL 
			///end FILTER_GRAPH_FUNCTION_SUPPORT
			) : MultiPaneDlg(IDD_PG_DLG, "ODlg8", !(dwCtrl & SELECT_MULTIPLE_PAGES))
	//------End CLEAN_UP_CONTROL_BITS_INTO_DWORD_FOR_GRAPH_BROWSER
	{
		m_vnPageTypes = nPageTypes;		
		m_strFilterFuncName = lpcszFilterFuncName; /// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT		
		
		/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT, get init view mode by fiter function
		//m_nViewMode = nViewMode; /// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_CHECKBOX
		///end FILTER_GRAPH_FUNCTION_SUPPORT
		
		string strPages(lpcszPages);
		if( !strPages.IsEmpty() )
		{
			strPages.GetTokens(m_vsPageList, STR_PAGE_LIST_SEPARATOR);
		}
		/// Kenny 07/17/2009 QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
#ifdef __ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		m_strDiff.SetTokens(m_vsPageList);
#endif // __ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		/// End QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		
		m_strDlgTitle = lpcszTitle;
		if(m_strDlgTitle.IsEmpty())
			m_strDlgTitle = _L(STR_DLG_NAME);
		
		m_strStartPEPath = lpcszStartPEpath;
		//------Folger 07/18/07 CLEAN_UP_CONTROL_BITS_INTO_DWORD_FOR_GRAPH_BROWSER
		//m_bShowFolders = bShowFolders;
		////m_strExclude = lpcszExclude;		///Folger 06/05/07 COMMENT_STR_EXCLUDE_PAGE
		//m_bMultiplePages = bMultiplePages;
		//m_bEnableEmbed = bEnableEmbed;		///Folger 05/29/07 ADD_BOOL_ENABLE_EMBED_IN_PAGE_PREVIEW_LIST_DLG		
		m_bMultiplePages = !!(dwCtrl & SELECT_MULTIPLE_PAGES);
		m_bShowFolders = !!(dwCtrl & SHOW_FOLDERS);
		m_bEnableEmbed = !!(dwCtrl & ENABLE_EMBEDED);
		/// Iris 5/04/2009 QA80-13552 SUPPORT_OPTION_TO_SORT_PAGE_LIST_AND_FILTER_3D_PAGE
		m_bSortPages = (dwCtrl & SORT_PAGE);
		m_bFilter3DGraph = (dwCtrl & FILTER_3D_GRAPH);
		///end SUPPORT_OPTION_TO_SORT_PAGE_LIST_AND_FILTER_3D_PAGE
		//-------Folger 07/19/07 CONTROL_BROWSE_PAGE_TYPE
		//m_bShowLayout = !!(dwCtrl & SHOW_LAYOUT);
		m_nPageType = nPageType;
		//-------End CONTROL_BROWSE_PAGE_TYPE
		//------End CLEAN_UP_CONTROL_BITS_INTO_DWORD_FOR_GRAPH_BROWSER
		m_bIncludeShortcut = false;	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
		
		/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
		PageViewOptions stPageOptions;
		getPageOptions(stPageOptions, true);
		SetPreviewOnRight(!m_bMultiplePages);
		///end FILTER_GRAPH_FUNCTION_SUPPORT	
		
		m_strRegisterName = m_bMultiplePages? STR_DLG_NAME_S : STR_DLG_NAME;///Jasmine 04/28/10 DLG_HAS_DIFF_SHAPE_AND_SAVE_DIFF_SIZE
	}	
	
	int DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();
		
		DWORD dwDlgOptions = 0;
		
		int nRet = DoModal(hWndParent, dwDlgOptions);
		
		m_vsPageList.RemoveAll();		///Folger 05/22/07 FIX_BUG_ON_SINGLE_SELECTION
		
		if(nRet != IDCANCEL || m_bCloseOnDBClick)	///Jasmine 12/19/06 ADD_DBCLICK_ON_TREE_PANEL
		{
			/// Iris 8/24/06 CONTROL_CHOOSE_ONLY_ONE_PAGE
			//return getPages();
			if(m_bMultiplePages)
			{
				return getPages();	
			}
			else
			{
				//m_vsPageList.RemoveAll();		///Folger 05/22/07 FIX_BUG_ON_SINGLE_SELECTION
				m_vsPageList.Add(getSelectedPage());			
			}
			///end CONTROL_CHOOSE_ONLY_ONE_PAGE
		}
		
		return nRet;
	}
	
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_READY(OnReady)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnDlgResize)
	ON_GETMINMAXINFO(OnMinMaxInfo) /// Iris 6/30/2009 SET_DLG_MIN_WIDTH
	
	ON_CONTEXTMENU(OnShowMenu)///Jasmine 07/12/06 ADD_CONTEXT_MENU
	ON_BN_CLICKED(IDC_SHOW_EMBEDDED, OnShowEmbeddedGraph)	///Jasmine 11/10/06 QA70-9112 GET_EMBEDDED_GRAPHS
	ON_BN_CLICKED(IDC_CHECK_LIST_VIEW, OnListViewClicked) /// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_CHECKBOX
	ON_BN_CLICKED(IDC_PG_SHORTCUT_CHECK, OnIncludeShortcut)	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	ON_BN_CLICKED(IDC_PM_UP_DOWN, OnShowPreview)
	ON_BN_CLICKED(IDC_MG_ADD, OnAdd)
	//ON_BN_CLICKED(IDC_ADD_OPEN_GP_BUTTON, OnAddAllOpen) ///Frank  11/11/05 ADD_ALL_OPEN_GRAPH_PAGE
	ON_BN_CLICKED(IDC_MG_REMOVE, OnRemove)
	//ON_BN_CLICKED(IDC_MG_UP, OnUp)
	//ON_BN_CLICKED(IDC_MG_DOWN, OnDown)
	ON_BN_CLICKED(IDOK, OnOK)
	ON_BN_CLICKED(IDCANCEL, OnCancel)
	//ON_BN_CLICKED(IDC_MG_SHOW_FULL_CHECK, OnShowFullPath)
	
	ON_GRID_ROW_COL_CHANGE(IDC_MG_GRPAH_LIST, OnSelectionChange)
	
	///Folger 04/03/07 ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER
	ON_GRID_BEFORE_MOVE_ROWS(IDC_MG_GRPAH_LIST, OnBeforeMoveRows)
	ON_GRID_AFTER_MOVE_ROWS(IDC_MG_GRPAH_LIST, OnAfterMoveRows)
	///End ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER
	
	ON_GRID_ROW_COL_CHANGE(IDC_FOLDER_TREE, OnSelectTreeNode)
	///Jasmine 10/24/06 REMBER_LAST_SELECTION 
	ON_GRID_CLICK(IDC_MG_GRPAH_LIST, OnSelectionChange)
	ON_GRID_CLICK(IDC_FOLDER_TREE, OnSelectTreeNode)
	///End REMBER_LAST_SELECTION
	ON_GRID_DBLCLICK(IDC_FOLDER_TREE, OnDblClickToSel)///Jasmine 12/19/06 ADD_DBCLICK_ON_TREE_PANEL
	//-------Joseph 2/14/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	ON_INIT_SIZE(OnInitSize)
	ON_RESTORESIZE(OnRestoreSize)
	//-------End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	ON_HELPINFO(OnHelp)
	
EVENTS_END

//------------ Event Handlers ------------------------
	///Jasmine 04/28/10 DLG_HAS_DIFF_SHAPE_AND_SAVE_DIFF_SIZE
	int	GetTotalHeight(bool bMin = false)
	{
		if( m_bMultiplePages && IsBottomPaneShown() )
		{
			RECT rSownBtn;
			GetClientRect(GetItem(IDC_PM_UP_DOWN), rSownBtn);
			return rSownBtn.bottom + PG_DLG_MIN_SIZE + 2*GetControlGap();
		}
		
		return PG_DLG_MIN_SIZE;
	}
	/// Iris 6/30/2009 SET_DLG_MIN_WIDTH
	int	GetTotalWidth(bool bMin = false)
	{
		int nCheckAndBtnsWidth, nCheckAndBtnsHeight;
		uint nCheckAndBtns[]={IDC_SHOW_EMBEDDED, IDC_CHECK_LIST_VIEW, IDOK, IDCANCEL, IDC_PM_UP_DOWN, 0};
		GetGroupTotalSize(nCheckAndBtns, nCheckAndBtnsWidth, nCheckAndBtnsHeight, true, PG_DLG_GAP*2);//PG_DLG_GAP*2 for larger space
		
		int nTitleWidth;
		GetTextExtentSize(m_strDlgTitle, &nTitleWidth);
		
		int nMainPaneWidth = max(nCheckAndBtnsWidth, nTitleWidth);
		
		if(m_bMultiplePages)
		{
			return nMainPaneWidth + PG_DLG_MIN_SIZE;
		}
		else
		{
			if( IsBottomPaneShown() )
			{
				RECT rSownBtn;
				GetClientRect(GetItem(IDC_PM_UP_DOWN), rSownBtn);
				return rSownBtn.right + PG_DLG_MIN_SIZE + 2*GetControlGap();
			}
		
			return nMainPaneWidth;				
		}
		///End CALCULATE_PG_DLG_SIZE
		
		/////Army 08/03/09 FIX_LISTVIEW_AND_OKBUTTON_OVERLAP_IN_J_AND_G
		////return MIN_MAIN_DLG_WIDTH;
		//char c = okutil_get_current_lang();
		//if(c == 'E')
			//return MIN_MAIN_DLG_WIDTH_E;
		//else if (c == 'J')
			//return MIN_MAIN_DLG_WIDTH_J;
		//else
			//return MIN_MAIN_DLG_WIDTH_G;
		/////End  FIX_LISTVIEW_AND_OKBUTTON_OVERLAP_IN_J_AND_G
	}
	///end SET_DLG_MIN_WIDTH
	///End DLG_HAS_DIFF_SHAPE_AND_SAVE_DIFF_SIZE
	
	//------ fisher 11/15/07 ADD_MAP_ID_TO_CHM
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus)
	{
		//------ Folger 08/15/08 DISABLE_GRAPH_BROWSER_HELP
		/// since help on graph browser is too simple, just disable for now, need improve later
		//nHelpID = IDD_GRAPH_BROWSER_DLG;
		//return true;
		return false;
		//------ End DISABLE_GRAPH_BROWSER_HELP
	}

	BOOL OnInitDialog()
	{
		waitCursor 		junk;
		
		vector<string>  vstrTipsUpDown;
		vstrTipsUpDown.SetSize(2);
		vstrTipsUpDown[0] = _L("Show Preview");
		vstrTipsUpDown[1] = _L("Hide Preview");
		//MultiPaneDlg::OnInitDialog(IDC_MG_GRPAH_LIST, IDC_PM_UP_DOWN, IDC_MG_PREVIEW, vstrTipsUpDown, "MergeGraphsDlg");
		MultiPaneDlg::OnInitDialog(IDC_FOLDER_TREE, IDC_PM_UP_DOWN, IDC_MG_PREVIEW, vstrTipsUpDown, m_strRegisterName);		
		
		Text = m_strDlgTitle;  //set dialog title	
		
		///Jasmine 10/24/06 SHOW_DEFAULT_FOLDER_PAGE
		if(!lstrlen(m_strStartPEPath))
		{
			Folder fld = Project.ActiveFolder();
			m_strStartPEPath = fld.GetPath();
		}
		///End SHOW_DEFAULT_FOLDER_PAGE
		
		GetItem(IDOK).Enable = false;	///Jasmine 02/06/07 DISABLE_OK_BUTTON_IF_NO_SELECTION		
		
		/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
		///------ Folger 06/19/09 QA80-13771 PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE
		m_bLName = true;	///Jasmine 02/24/07 by Easwar's request, turn it on by default
		vector<byte>	vbSettings;
		if ( load_default_checkboxes(STR_DIALOG_NAME, vbSettings, STR_LIST_SETTINGS) )
		{
			m_bLName = vbSettings[LIST_SETTING_SHOW_LN];
			m_bCell = vbSettings[LIST_SETTING_SHOW_CELL_INFO];
		}
		///------ End PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE
		PageViewOptions stPageOptions;
		getPageOptions(stPageOptions, true);
		///end FILTER_GRAPH_FUNCTION_SUPPORT
		
		Button chkShowEmbedded = GetItem(IDC_SHOW_EMBEDDED);
		///Jasmine 11/17/06 SHOW_LNAME_AND_CELL
		///Jasmine 11/21/06 FIX_TREE_PANE_FAIL_TO_DISPLAY, should init m_pcPrev first
		chkShowEmbedded.Text = _L("Show Embedded Graph");			
	
		/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
		chkShowEmbedded.Check = stPageOptions.stProjectTreeOptions.bGetEmbeddedGraph;
		///end FILTER_GRAPH_FUNCTION_SUPPORT
		
		///Jasmine 01/24/07 SAVE_EMBEDDED_CHECK_BOX_SETTING
		//chkShowEmbedded.Check = m_bEmbed = 1;
		ResizeDialog::LoadCheckBoxSettings(STR_DLG_NAME, IDC_SHOW_EMBEDDED);		
		///Folger 05/29/07 ADD_BOOL_ENABLE_EMBED_IN_PAGE_PREVIEW_LIST_DLG
		if (!m_bEnableEmbed)
		{
			chkShowEmbedded.Check = false;
			chkShowEmbedded.Enable = false;
		}
		///End ADD_BOOL_ENABLE_EMBED_IN_PAGE_PREVIEW_LIST_DLG
		m_bEmbed = chkShowEmbedded.Check;
		stPageOptions.stProjectTreeOptions.bGetEmbeddedGraph = chkShowEmbedded.Check; /// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT, LoadCheckBoxSettings will apply checkbox setting from register
		
		///Folger 04/09/07 SHOW_EMBEDED_GRAPH_PATH
		if (!m_bEmbed)
		{
			for (int ii=0; ii<m_vsPageList.GetSize(); ii++)
			{
				GraphPage gp(m_vsPageList[ii]);
				if (gp && gp.GetEmbeddingInfo())
				{
					m_bEmbed = chkShowEmbedded.Check = true;
					stPageOptions.stProjectTreeOptions.bGetEmbeddedGraph = m_bEmbed; /// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
					break;
				}
			}
		}
		///End SHOW_EMBEDED_GRAPH_PATH		
		
		///End SHOW_LNAME_AND_CELL
		
		///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
		Button chkShortcut = GetItem(IDC_PG_SHORTCUT_CHECK);
		chkShortcut.Check = (stPageOptions.stProjectTreeOptions.dwCtrl & PT_CTRL_INCLUDE_SHORTCUT);
		///End BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
		
		///------ Folger 06/19/09 QA80-13771 PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE
		//m_bLName = true;	///Jasmine 02/24/07 by Easwar's request, turn it on by default
		///------ End PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE
		Control ctrlPre = GetItem(IDC_MG_PREVIEW);
	    m_pcPrev.CreateControl(ctrlPre.GetSafeHwnd());
	    
	    /// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_CHECKBOX
	    //initFolderTree(m_bEmbed);	
	    ///End SAVE_EMBEDDED_CHECK_BOX_SETTING
		
		/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
		Button btnViewMode = GetItem(IDC_CHECK_LIST_VIEW);
		if( btnViewMode )
		{
			btnViewMode.Visible = stPageOptions.bViewModeControlShow;
			btnViewMode.Check = VIEW_MODE_LIST == stPageOptions.nViewMode? 1 : 0;
		}
		///end FILTER_GRAPH_FUNCTION_SUPPORT
		
		m_PageView.SetViewMode(stPageOptions.nViewMode);
		m_PageView.InitControl(*this, stPageOptions);
		///end ADD_LIST_VIEW_CHECKBOX
		
		///Folger 04/03/07 ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER
		//initGraphsList(); // init controls
		Tree tr;
		initGraphsList(tr); // init controls
		///End ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER
		
		//InitDynaControl(IDC_LAYERTOOL_FRAME);
		/// Iris 8/24/06 CONTROL_CHOOSE_ONLY_ONE_PAGE
		if(!m_bMultiplePages)
		{
			Button btAdd = GetItem(IDC_MG_ADD);
			Button btRemove = GetItem(IDC_MG_REMOVE);
			btAdd.Visible = false;
			btRemove.Visible = false;			
		}	
		///end CONTROL_CHOOSE_ONLY_ONE_PAGE
		
		//m_CheckBtn = GetItem(IDC_MG_SHOW_FULL_CHECK);
		///Jasmine 11/25/05 QA70-8352 v8.0340 OPEN_PAGE_PREVIEW_LIST_DLG
		//Control ctrlPre = GetItem(IDC_MG_PREVIEW);
	    //m_pcPrev.CreateControl(ctrlPre.GetSafeHwnd());
	    //---- CPY 12/11/05 REMOVE_FO_CODE_FROM_PROJ_BROWER	
		//m_NFunctionPrev.Init(IDC_MG_PREVIEW,*this, 0, "");
		//Control ctrlPre = GetItem(IDC_MG_PREVIEW);
	    //m_pcPrev.CreateControl(ctrlPre.GetSafeHwnd());
		//----
		///End OPEN_PAGE_PREVIEW_LIST_DLG		
		///End FIX_TREE_PANE_FAIL_TO_DISPLAY
		m_bCloseOnDBClick = false;	///Jasmine 12/19/06 ADD_DBCLICK_ON_TREE_PANEL
		return true;
	}	
	
	///------ Folger 06/19/09 QA80-13771 PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE
	BOOL	OnDestroy()
	{
		MultiPaneDlg::OnDestroy();/// Iris 6/26/2009 WANT_SAVE_DOWNUP_BUTTON_STATE_IN_REGISTER
		
		checkUpdateListSettings();

		vector<byte>	vbSettings(LIST_SETTING_TOTAL);
		vbSettings[LIST_SETTING_SHOW_LN] = m_bLName;
		vbSettings[LIST_SETTING_SHOW_CELL_INFO] = m_bCell;
		save_default_checkboxes(STR_DIALOG_NAME, vbSettings, STR_LIST_SETTINGS);

		return TRUE;
	}
	///------ End PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE
	
	BOOL OnReady()
	{
	    //inti dialog
	    //------Joseph  02/14/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
		//UpdateDlgSize();		
		//------End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS-
		UpdateDlgShow();
		SetInitReady();				
		
		/// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_CHECKBOX
		//m_trFolder.SetReady(); 
		m_PageView.SetReady();
		///end ADD_LIST_VIEW_CHECKBOX
		
		m_list.SetReady();	
		if(getPages() && m_bMultiplePages)
		{
			/// Iris 6/26/2009 QA80-13711 PREVIEW_SHOULD_SHOW_FIRST_IN_LIST_WHEN_DLG_OPEN
			//m_list.SelRow(0);
			m_list.SelRow(m_list.GetRowOffset());
			///end PREVIEW_SHOULD_SHOW_FIRST_IN_LIST_WHEN_DLG_OPEN
		}
		
		return TRUE;
	}
	
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		if(!IsInitReady())
			return TRUE;
		MoveControlsHelper	_temp(this);		///Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS	
		///Frank  11/11/05 ADD_ALL_OPEN_GRAPH_PAGE
		//uint nButtonIDs[] = {IDC_MG_ADD, IDC_MG_REMOVE, IDC_MG_UP, IDC_MG_DOWN, IDOK, IDCANCEL, 0};
		//uint nButtonIDs[] = {IDC_MG_ADD,IDC_ADD_OPEN_GP_BUTTON, IDC_MG_REMOVE, IDC_MG_UP, IDC_MG_DOWN, IDOK, IDCANCEL, 0};
		///End ADD_ALL_OPEN_GRAPH_PAGE
		uint nButtonIDs[] = {IDCANCEL, IDOK, 0};
		
		MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy, false);
		
		/// Iris 6/30/2009 FIX_SHOW_FRAME_IN_INCORRECT_PLACE_WHEN_OPEN_DLG_WITH_PREVIEW_PANEL_HIDDEN
		if( !IsBottomPaneShown() )
		{
			Control ctrl = GetItem(IDC_MG_PREVIEW);
			ctrl.Visible = false;
		}		
		///end FIX_SHOW_FRAME_IN_INCORRECT_PLACE_WHEN_OPEN_DLG_WITH_PREVIEW_PANEL_HIDDEN
		
		resizeControls(cx);
		return TRUE;
	}
	//-------Joseph 2/14/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	BOOL OnInitSize(int &left, int &top, int &right, int  &bottom)
	{
		return FALSE;
	}
	BOOL OnRestoreSize(DWORD dwSizeInfo)
	{
		void * p = (void*)dwSizeInfo;
		DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
		
		lstrcpyn(pSz->szDialogName, m_strRegisterName, MAXLINE);
		///Joseph 02/15/07 ROLL_BRAK_TO_TD_DESIGN
		//pSz->top = -150;
		//pSz->left = -300;
		pSz->top = -1;
		pSz->left = -1;
		///End ROLL_BRAK_TO_TD_DESIGN
		///Army 08/07/09 FIX_LISTVIEW_AND_OKBUTTON_OVERLAP_IN_J_AND_G
		//pSz->width = 620;  //hard code, will change later
		pSz->width = 680;  //hard code, will change later
		///End FIX_LISTVIEW_AND_OKBUTTON_OVERLAP_IN_J_AND_G
		pSz->height = 500;  //hard code, will change later
		return TRUE;
	}
	//-------End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	
	///Jasmine 07/12/06 ADD_CONTEXT_MENU
	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny)
	{
		/// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_MODE
		//if(IDC_FOLDER_TREE == nResIDCtrl)
		/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
		//if(IDC_FOLDER_TREE == nResIDCtrl && m_nViewMode == VIEW_MODE_PE)
		if(IDC_FOLDER_TREE == nResIDCtrl && isListViewChecked() == VIEW_MODE_PE)
		///end FILTER_GRAPH_FUNCTION_SUPPORT
		///end ADD_LIST_VIEW_MODE
			return showProjectTreeMenu(nx, ny);
		
		if(IDC_MG_GRPAH_LIST == nResIDCtrl)
			return showSelListMenu(nx, ny);
		
		///------ Folger 06/19/09 QA80-13771 PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE
		if ( IDC_FOLDER_TREE == nResIDCtrl && NULL != m_PageView.GetListViewPointer() )
			return  m_PageView.GetListViewPointer()->CheckShowContextMenu(nx, ny);
		///------ End PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE
		
		return FALSE;
	}
	
private:	
	/// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_CHECKBOX
	void getPageOptions(PageViewOptions& stPageOptions, bool bInit = false)
	{
		// Init structure from member data. 
		// !!!These member data should be replace with structure later, but now need keep smallest change in SR6.
		stPageOptions.nPageType = m_nPageType;
		stPageOptions.bMultiplePages = m_bMultiplePages;
		stPageOptions.bShowFolders = m_bShowFolders;
		stPageOptions.strStartPEPath = m_strStartPEPath;
		// if not filter function, the default view mode and show view mode checkbox
		stPageOptions.nViewMode = VIEW_MODE_PE; 
		stPageOptions.bViewModeControlShow = true;
		stPageOptions.strFilterFuncName = m_strFilterFuncName;
		stPageOptions.stProjectTreeOptions.bSortPages = m_bSortPages;
		stPageOptions.stProjectTreeOptions.bFilter3DGraph = m_bFilter3DGraph;
		
		stPageOptions.bLongNameShow = m_bLName;
		stPageOptions.bCellShow = m_bCell;
		stPageOptions.bEmbedControlEnable = m_bEnableEmbed;		
		stPageOptions.stProjectTreeOptions.bGetEmbeddedGraph = m_bEmbed;	
		
		///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
		DWORD dwTemp = stPageOptions.stProjectTreeOptions.dwCtrl | PT_CTRL_INCLUDE_SHORTCUT;
		if(!m_bIncludeShortcut)
			dwTemp &= ~PT_CTRL_INCLUDE_SHORTCUT;
		stPageOptions.stProjectTreeOptions.dwCtrl = dwTemp;				
		///End BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
		
		/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
		if( NULL != m_strFilterFuncName && bInit )
		{			
			bool bRet = _get_page_view_options_by_filter_func(stPageOptions);
			ASSERT( bRet );
			if( bRet )
			{			
				m_nPageType = stPageOptions.nPageType;
				m_bMultiplePages = stPageOptions.bMultiplePages;
				m_bShowFolders = stPageOptions.bShowFolders;
				m_strStartPEPath = stPageOptions.strStartPEPath;
				m_bSortPages = stPageOptions.stProjectTreeOptions.bSortPages;
				m_bFilter3DGraph = stPageOptions.stProjectTreeOptions.bFilter3DGraph;
				
				m_bLName = stPageOptions.bLongNameShow;
				m_bCell = stPageOptions.bCellShow;
				m_bEnableEmbed = stPageOptions.bEmbedControlEnable;
				m_bEmbed = stPageOptions.stProjectTreeOptions.bGetEmbeddedGraph;
				
				///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
				m_bIncludeShortcut = (stPageOptions.stProjectTreeOptions.dwCtrl & PT_CTRL_INCLUDE_SHORTCUT);
				///End BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
			}
		}
		///end FILTER_GRAPH_FUNCTION_SUPPORT
		
		/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
		// the following options got from fiter function is init state
		if( !bInit )
		{
			stPageOptions.nViewMode = isListViewChecked();
		}
		///end FILTER_GRAPH_FUNCTION_SUPPORT
	}
	///end ADD_LIST_VIEW_CHECKBOX

	BOOL showProjectTreeMenu(int nx, int ny)
	{
		/// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_CHECKBOX
		/*
		bool bFolder, bMulti;		
		vector<uint> vnSelRows;
		m_trFolder.GetSelRows(vnSelRows);
		int nSize = vnSelRows.GetSize();
		bMulti = nSize > 1;
		int nClickRow, nClickCol;
		m_trFolder.GetMouseCell(nClickRow, nClickCol);
		if(0 <= nClickRow)
		{
			vector<uint> vecIndex;
			vnSelRows.Find(vecIndex, nClickRow);
			if(!vecIndex.GetSize())
			{
				m_trFolder.SelRow(nClickRow);
				bMulti = false;
			}
			else
				nClickRow = vnSelRows[0];
		}
			
		TreeNode tr = tree_get_node(m_tree, nClickRow);
		if(tr.IsValid())
			bFolder = tr.GetNodeCount() > 0;
		*/		
		bool bMulti;
		bool bFolder = m_PageView.GetPEViewPointer()->IsFolderSelected(&bMulti);
		///end ADD_LIST_VIEW_CHECKBOX
		
		///Jasmine 11/17/06 SHOW_LNAME_AND_CELL
		/// Kenny 09/08/2009 IMPROVE_SHOW_HIDE_CONTEXT_MENU
		//ProjectTreeMenu	myMenu(bFolder, bMulti, m_bLName, m_bEmbed, m_bCell);
		bool bAddingItems = m_list.IsVisible();
		ProjectTreeMenu	myMenu(bFolder, bMulti, m_bLName, m_bEmbed, m_bCell, bAddingItems);
		/// End IMPROVE_SHOW_HIDE_CONTEXT_MENU
		myMenu.TrackPopupMenu(0,  nx, ny, GetSafeHwnd());
		int nCmd;
		if(myMenu.GetCommand(nCmd))
		{
			BeforeUpdate();		
			switch(nCmd)
			{
			case PROJECT_TR_ADD_ALL:
				addSelected();
				break;
			case PROJECT_TR_ADD_ALL_RECURSIVE:
				addSelected(true);
				break
			case PROJECT_TR_ADD_ALL_OPEN:
				addSelected(false, true);
				break;
			case PROJECT_TR_SHOW_LNAME:
				m_bLName = !m_bLName;
				/// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_MODE
				//ShowMoreInfo(m_bLName, m_bCell);
				m_PageView.GetPEViewPointer()->ShowMoreInfo(m_bLName, m_bCell);
				///end ADD_LIST_VIEW_MODE
				break;
			case PROJECT_TR_SHOW_CELL:
				m_bCell = !m_bCell;
				/// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_MODE
				//ShowMoreInfo(m_bLName, m_bCell);
				m_PageView.GetPEViewPointer()->ShowMoreInfo(m_bLName, m_bCell);
				///end ADD_LIST_VIEW_MODE
				break;
		///End SHOW_LNAME_AND_CELL
			default:
				break;				
			}
			selectRow(m_list.GetRows() - 1);	///Jasmine 10/24/06 REMBER_LAST_SELECTION
			AfterUpdate();
			return TRUE;
		}
		return FALSE;
		
	}
	BOOL showSelListMenu(int nx, int ny)
	{		
		vector<uint> vnSelRows;
		m_list.GetSelRows(vnSelRows);
		bool bMulti = vnSelRows.GetSize() > 1;
		
		int nClickRow, nClickCol;
		m_list.GetMouseCell(nClickRow, nClickCol);
		///Folger 04/04/07 MODIFY_GRAG_AND_DROP_TO_GRAPH_BROWSER
		if (nClickRow == 0) return FALSE;
		if(1 <= nClickRow)
		//if(0 <= nClickRow)
		///End MODIFY_GRAG_AND_DROP_TO_GRAPH_BROWSER
		{
			vector<uint> vecIndex;
			vnSelRows.Find(vecIndex, nClickRow);
			if(!vecIndex.GetSize())
			{
				m_list.SelRow(nClickRow);
				bMulti = false;
			}
		}
		
		SelListMenu	myMenu(bMulti);
		myMenu.TrackPopupMenu(0,  nx, ny, GetSafeHwnd());
		int nCmd;
		if(myMenu.GetCommand(nCmd))
		{
			Control cntrl;
			switch(nCmd)
			{
			case SEL_LIST_REMOVE:
				OnRemove(cntrl);
				break;
			///Jasmine 01/22/07 UNCOMMENT_FOR_DRAG_AND_DROP_NOT_READY
			/// Iris 8/24/06 SUPPORT_DROP_LIST_LIKE_XF_BUILDER	
			case SEL_LIST_UP:
				OnUp(cntrl);
				break;
			case SEL_LIST_DOWN:
				OnDown(cntrl);
				break;	
			//end SUPPORT_DROP_LIST_LIKE_XF_BUILDER
			///End UNCOMMENT_FOR_DRAG_AND_DROP_NOT_READY
			default:
				break;
			}
			return TRUE;
		}
		return FALSE;
		
	}
	///End ADD_CONTEXT_MENU
	
protected:
	///Jasmine 11/10/06 QA70-9112 GET_EMBEDDED_GRAPHS
	BOOL OnShowEmbeddedGraph(Control cntrl)
	{		
		Button chkShowEmbedded = GetItem(IDC_SHOW_EMBEDDED);
		m_bEmbed = chkShowEmbedded.Check;///Jasmine 11/17/06 SHOW_LNAME_AND_CELL
		/// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_MODE
		//UpdateTreePane(m_bEmbed);
		m_PageView.SetEmbeddedShow(m_bEmbed);
		m_PageView.UpdatePageView();
		///end ADD_LIST_VIEW_MODE
		return TRUE;
	}
	///End GET_EMBEDDED_GRAPHS
	
	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	BOOL OnIncludeShortcut(Control cntrl)
	{
		Button chkIncludeShortcut = GetItem(IDC_PG_SHORTCUT_CHECK);
		m_bIncludeShortcut = chkIncludeShortcut.Check;
		
		m_PageView.SetIncludeShortcut(m_bIncludeShortcut);
		m_PageView.UpdatePageView();
		return TRUE;
	}
	///End BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	
	/// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_MODE
	int isListViewChecked()
	{
		Button btnListView = GetItem(IDC_CHECK_LIST_VIEW);
		//ASSERT( btnListView );
		
		if( btnListView )
			return btnListView.Check? VIEW_MODE_LIST : VIEW_MODE_PE;		
		else
			return m_PageView.GetViewMode();
	}
	
	BOOL OnListViewClicked(Control cntrl)
	{
		/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
		//Button btnListView = GetItem(IDC_CHECK_LIST_VIEW);
		//m_nViewMode = btnListView.Check? VIEW_MODE_LIST : VIEW_MODE_PE;
		///end FILTER_GRAPH_FUNCTION_SUPPORT
		
		checkUpdateListSettings();			///------ Folger 06/19/09 QA80-13771 PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE
		
		PageViewOptions stPageOptions;
		getPageOptions(stPageOptions);
		
		/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
		//m_PageView.SetViewMode(m_nViewMode);
		m_PageView.SetViewMode(stPageOptions.nViewMode);
		///end FILTER_GRAPH_FUNCTION_SUPPORT
				
		m_PageView.InitControl(*this, stPageOptions);
		return TRUE;
	}
	///end ADD_LIST_VIEW_MODE
	
	BOOL OnShowPreview(Control cntrl)
	{
		MultiPaneDlg::OnShowBottomPane(cntrl);		
		
		if(IsBottomPaneShown())				
			///Jasmine 10/24/06 REMBER_LAST_SELECTION
			//updateShowPreview();		
			loadGraphPageThumbnail(m_strSel);
			///End REMBER_LAST_SELECTION
		
		return TRUE;
	}
	
	BOOL OnAdd(Control cntrl)
	{
		BeforeUpdate();
		addSelected();
		selectRow(m_list.GetRows() - 1);	///Jasmine 10/24/06 REMBER_LAST_SELECTION
		AfterUpdate();
		return TRUE;
	}
	
	BOOL OnRemove(Control cntrl)
	{
		BeforeUpdate();
		removeSelectedPages();
		///Jasmine 10/24/06 REMBER_LAST_SELECTION 
		//updateShowPreview();
		AfterUpdate();
		OnSelectionChange(cntrl);
		///End REMBER_LAST_SELECTION
		/// Kenny 07/17/2009 QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
#ifdef	__ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		updateOKBtnStatus();
#else
		/// End QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		GetItem(IDOK).Enable = (0 < m_list.GetRows() - m_list.GetRowOffset());	///Jasmine 02/06/07 DISABLE_OK_BUTTON_IF_NO_SELECTION
#endif	/// Kenny 07/17/2009 QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		return TRUE;
	}
	///Jasmine 01/22/07 UNCOMMENT_FOR_DRAG_AND_DROP_NOT_READY
	
	/// Iris 8/24/06 SUPPORT_DROP_LIST_LIKE_XF_BUILDER
	BOOL OnUp(Control cntrl)
	{
		BeforeUpdate();
		moveRowUp();
		/// Kenny 07/17/2009 QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
#ifdef __ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		updateOKBtnStatus();
#else
		/// End QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		GetItem(IDOK).Enable = true;
#endif	/// Kenny 07/17/2009 QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		AfterUpdate();
		return TRUE;
	}
	
	BOOL OnDown(Control cntrl)
	{
		BeforeUpdate();
		moveRowDown();
		/// Kenny 07/17/2009 QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
#ifdef __ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		updateOKBtnStatus();
#else
		/// End QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		GetItem(IDOK).Enable = true;
#endif	/// Kenny 07/17/2009 QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		AfterUpdate();
		return TRUE;
	}
	///end SUPPORT_DROP_LIST_LIKE_XF_BUILDER
	///End UNCOMMENT_FOR_DRAG_AND_DROP_NOT_READY
	BOOL OnOK(Control cntrl)
	{		
		ResizeDialog::SaveCheckBoxSettings();	///Jasmine 01/24/07 SAVE_EMBEDDED_CHECK_BOX_SETTING
		return TRUE;
	}
	
	BOOL OnCancel(Control cntrl)
	{
		return TRUE;
	}

	BOOL OnSelectionChange(Control cntrl)
	{
		if(!m_list.IsReady())
		{
			_DMSG_MG("list is not ready");			
			return false;
		}
		///Jasmine 10/24/06 REMBER_LAST_SELECTION		
		vector<string> 	vsItems;
		m_list.GetSelItems(COL_INDEX, vsItems);
		string 		strPage;
		if(vsItems.GetSize() > 0)
			strPage = vsItems[0];
		
		if(isFullPath(strPage))
			strPage = getPageNameFromFullPath(strPage);
		m_strSel = strPage;
		if(!IsBottomPaneShown())
		{
			_DMSG_MG("preview should be hidden");			
			return false;
		}		
		
		//return updateShowPreview();
		return loadGraphPageThumbnail(m_strSel);
		///End REMBER_LAST_SELECTION
	}
	
	BOOL OnSelectTreeNode(Control cntrl)
	{		
		if(!m_bMultiplePages)
			GetItem(IDOK).Enable = false;	///Jasmine 02/06/07 DISABLE_OK_BUTTON_IF_NO_SELECTION
		
		/// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_CHECKBOX
		/*
		///Jasmine 10/24/06 REMBER_LAST_SELECTION
		vector<uint> vnSelRows;
		m_trFolder.GetSelRows(vnSelRows);
		if(vnSelRows.GetSize() < 1)
			return false;
		TreeNode tr = tree_get_node(m_tree, vnSelRows[0]);
		if(!tr.IsValid() || tr.GetNodeCount() > 0)///Jasmine 11/21/06 FIX_TREE_PANE_FAIL_TO_DISPLAY
			return false;
		string strName;
		///Jasmine 11/03/06 SHOULD_SHOW_SHORT_NAME
		//tr.GetAttribute(STR_NAME_ATTRIB, strName);
		tr.GetAttribute(STR_LABEL_ATTRIB, strName);
		///End SHOULD_SHOW_SHORT_NAME
		///Jasmine 02/06/07 DISABLE_OK_BUTTON_IF_NO_SELECTION
		int nDisplay;
		tr.GetAttribute(STR_DISPLAY_ATTRIB, nDisplay);
		if(!m_bMultiplePages && nDisplay == get_page_display_id(EXIST_PLOT))
			GetItem(IDOK).Enable = true;	
		///End DISABLE_OK_BUTTON_IF_NO_SELECTION
		m_strSel = strName;
		*/
		vector<string> 	vsPages;
		vector<int> 	vnDisplayIDs;
		if( m_PageView.GetSelectedPages(vsPages, true, &vnDisplayIDs) <= 0 )
			return false;
		
		/// Kenny 07/17/2009 QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
#ifdef __ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		if ( !m_bMultiplePages )
			updateOKBtnStatus();
#else
		/// End QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		if(!m_bMultiplePages && (vnDisplayIDs.GetSize() > 0 && vnDisplayIDs[0] == get_page_display_id(EXIST_PLOT) || 0 == vnDisplayIDs.GetSize() ) )
			GetItem(IDOK).Enable = true;
#endif	/// Kenny 07/17/2009 QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY

		m_strSel = vsPages[0];
		///end ADD_LIST_VIEW_CHECKBOX
		
		if(!IsBottomPaneShown())
		{
			_DMSG_MG("preview should be hidden");			
			return false;
		}		
		//return updateShowPreviewFromTree();
		return loadGraphPageThumbnail(m_strSel);
		///End REMBER_LAST_SELECTION
	}
	
	///Jasmine 12/19/06 ADD_DBCLICK_ON_TREE_PANEL
	bool OnDblClickToSel(Control ctrl)
	{		
		if(m_bMultiplePages)//add selected item to graph list
		{
			Control cntrl;
			return OnAdd(cntrl);
		}
		
		//select and close dlg
		///Jasmine 02/06/07 DISABLE_OK_BUTTON_IF_NO_SELECTION
		/// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_CHECKBOX
		/*
		//check if click on a good node
		vector<uint> vnSelRows;
		m_trFolder.GetSelRows(vnSelRows);
		if(vnSelRows.GetSize() < 1)
			return false;
		TreeNode tr = tree_get_node(m_tree, vnSelRows[0]);
		int nDisplay;
		if(!tr.IsValid() || !tr.GetAttribute(STR_DISPLAY_ATTRIB, nDisplay) || nDisplay != get_page_display_id(EXIST_PLOT))
			return false;
		*/
		vector<string> vsPages;
		if( 0 == m_PageView.GetSelectedPages(vsPages) )
			return false;
		Page pg(vsPages[0]);
		if( !pg || EXIST_PLOT != pg.GetType() )
			return false;
		///end ADD_LIST_VIEW_CHECKBOX
		///End DISABLE_OK_BUTTON_IF_NO_SELECTION
		m_bCloseOnDBClick = true;
		PostMessage( WM_CLOSE );
		return true;
	}
	///End ADD_DBCLICK_ON_TREE_PANEL
	
	void BeforeUpdate()
	{
		m_list.SetReady(false);
	}
	
	void AfterUpdate(bool bResizeCols = true)
	{	
		m_list.SetReady(true);
	}

private:
	/// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_CHECKBOX
	/*
	//----init dialog
	///Jasmine 11/10/06 QA70-9112 GET_EMBEDDED_GRAPHS
	void initFolderTree(bool bShowEmbedded = true)
	{		
		m_trFolder.Init(IDC_FOLDER_TREE, *this);
		
		m_trFolder.SetSelection(flexSelectionListBox);
		m_trFolder.SetAllowSelection(m_bMultiplePages);
		
		UpdateTreePane(bShowEmbedded);
	}
	///End GET_EMBEDDED_GRAPHS
	*/
	///end ADD_LIST_VIEW_CHECKBOX
	
	///------ Folger 06/19/09 QA80-13771 PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE
	void	checkUpdateListSettings()
	{
		PageListView*		pListView = m_PageView.GetListViewPointer();
		if ( NULL != pListView )
		{
			vector<byte>	vbHide;
			pListView->GetHiddenCols(vbHide);
			m_bLName = !vbHide[LIST_LONG_NAME_COL];
			m_bCell = !vbHide[LIST_CELL_LOCATION_COL];
		}
	}
	///------ End PAGE_VIEW_GRID_CONTROL_SETTINGS_BACKUP_AND_RESTORE
	
	///Folger 04/03/07 ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER
	void OnBeforeMoveRows(Control ctrl, long nRow, long *pnPosition)
	{
		getPages();
		m_strDiff.SetTokens(m_vsPageList);
	}
	
	void OnAfterMoveRows(Control ctrl, long nRow, long *pnPosition) 
	{
		getPages();
		/// Kenny 07/17/2009 QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
#ifdef __ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		updateOKBtnStatus(false);
#else
		/// End QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		string strTmp;
		strTmp.SetTokens(m_vsPageList);
		if (strTmp.CompareNoCase(m_strDiff) != 0)
		{
			GetItem(IDOK).Enable = true;
		}
#endif	/// Kenny 07/17/2009 QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
	}
	//End ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER
	
	void initGraphsList(Tree& tr)	
	{
		m_list.Init(IDC_MG_GRPAH_LIST, false, true, NULL, *this);
		/// Iris 8/24/06 CONTROL_CHOOSE_ONLY_ONE_PAGE
		if(!m_bMultiplePages)
		{
			m_list.SetVisible(false);
			return;
		}
		///end CONTROL_CHOOSE_ONLY_ONE_PAGE
		
		m_list.SetReady(false);
		m_list.SetAllowSelection(true);
		m_list.SetSelection(flexSelectionListBox);
		m_list.SetEditable();
		m_list.SetupRowsCols(0, 0,  1, 2);
		m_list.SetTreeNodeMoveRowsAttrib(tr);
		m_list.SetReady(true);
		
		Tree trPages;
		bool bFlag = false;					///Folger 04/05/07 MODIFY_GRAG_AND_DROP_TO_GRAPH_BROWSER_1
		
		for (int ii=0; ii<m_vsPageList.GetSize(); ii++)
		{
			string strName = m_vsPageList[ii];
			//-------Folger 07/18/07 SHOW_BOTH_GRAPH_AND_LAYOUT_IN_TREE_PANEL
			//GraphPage gp(strName);
			//if (gp || layout)
			GraphPageBase gpb(strName);
			if (gpb)
			//-------End SHOW_BOTH_GRAPH_AND_LAYOUT_IN_TREE_PANEL
			{
				bFlag = true;				///Folger 04/05/07 MODIFY_GRAG_AND_DROP_TO_GRAPH_BROWSER_1
				TreeNode trnode = trPages.AddNode(strName);
				trnode.Name.strVal = strName;
				trnode.Path.strVal = getFullPathFromPageName(strName);
			}			
		}
		
		///Folger 04/05/07 MODIFY_GRAG_AND_DROP_TO_GRAPH_BROWSER_1
		//In case there is no input pages or invalid pages
		//Add a new node to update the grid
		if (!bFlag)
		{
			TreeNode trnode = trPages.AddNode();
			trnode.Name.strVal = "";
			trnode.Path.strVal = "";
		}
		//End MODIFY_GRAG_AND_DROP_TO_GRAPH_BROWSER_1
		
		m_list.SetReady(false);
		int nSelRow = m_list.GetSelectedRow();
		m_list.UpdateGrid(trPages);
		m_list.SelRow(nSelRow);
		m_list.SetRowHeaderValues();
		m_list.ResizeCols();
		m_list.SetReady(true);
		
		///Folger 04/05/07 MODIFY_GRAG_AND_DROP_TO_GRAPH_BROWSER_1
		//In case there is no input pages or invalid pages
		//Delete the empty line(second ine)
		if (!bFlag)
		{
			m_list.DeleteRow(m_list.GetRowOffset());
		}
		//End MODIFY_GRAG_AND_DROP_TO_GRAPH_BROWSER_1
	}
	///Folger ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER
	
	void resizeControls(int cx)
	{		
		int nGap = PG_DLG_GAP;

		Control ctrlTree = GetItem(IDC_FOLDER_TREE);
		RECT 	rrTree;
		GetClientRect(ctrlTree, rrTree);
		
		///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
		//shorten ctrlTree to place shortcut checkbox
		Control chkShortcut = GetItem(IDC_PG_SHORTCUT_CHECK);
		RECT 	rShortcut;
		GetClientRect(chkShortcut, rShortcut);
		int nChkWidth = RECT_WIDTH(rShortcut);
		int nChkHeight = RECT_HEIGHT(rShortcut);
		rShortcut.left 	= nGap;
		rShortcut.right = rShortcut.left + nChkWidth;
		rShortcut.bottom = rrTree.bottom;
		rShortcut.top	= rShortcut.bottom - nChkHeight;
		MoveControl(chkShortcut, rShortcut);
		
		rrTree.bottom = rShortcut.top - nGap;
		MoveControl(ctrlTree, rrTree);
		///End BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
		
		Control ctrlList = GetItem(IDC_MG_GRPAH_LIST);
		RECT 	rrList;
		GetClientRect(ctrlList, rrList);
		
		if(m_bMultiplePages)
		{
			Control btnAdd = GetItem(IDC_MG_ADD);
			RECT 	rrAdd;
			GetClientRect(btnAdd, rrAdd);
			int nBtnWidth = RECT_WIDTH(rrAdd);
			
			// WeightDlg = Gap + TreeWid + Gap + ButtonWid + ListWid + Gap, the width of List is same as the width of Tree
			int nTreeAndListWidth = ( RECT_WIDTH(rrTree) - 3*nGap - nBtnWidth )/2;
			
			rrList.top = rrTree.top;
			rrList.bottom = rrTree.bottom;
			rrList.right = rrTree.right;
			rrList.left = rrList.right - nTreeAndListWidth;
			MoveControl(ctrlList, rrList);
			
			
			Control btnRemove = GetItem(IDC_MG_REMOVE);
			RECT 	rrRemove;
			GetClientRect(btnRemove, rrRemove);
		
			rrAdd.right = rrList.left - nGap;
			rrAdd.left = rrAdd.right - nBtnWidth;
			MoveControl(btnAdd, rrAdd);
			
			rrRemove.right = rrAdd.right;
			rrRemove.left = rrAdd.left;
			MoveControl(btnRemove, rrRemove);
			
			rrTree.right = rrAdd.left - nGap;
		///Jasmine 11/17/06 SHOW_LNAME_AND_CELL, set preview on the side if select single page
			MoveControl(ctrlTree, rrTree);
		}
		//else
		//{
			//rrTree.right = cx;
		//}
		///End SHOW_LNAME_AND_CELL
		///Jasmine 11/10/06 QA70-9112 GET_EMBEDDED_GRAPHS
		Control chkEmbed = GetItem(IDC_SHOW_EMBEDDED);
		RECT 	rrCheck, rrOK;
		GetClientRect(chkEmbed, rrCheck);
		int nWidth = RECT_WIDTH(rrCheck), nHeight = RECT_HEIGHT(rrCheck);
		GetClientRect(GetItem(IDOK), rrOK);
		rrCheck.left = rrTree.left;
		rrCheck.top = rrOK.top;
		rrCheck.right = rrCheck.left + nWidth;
		rrCheck.bottom = rrCheck.top + nHeight;
		MoveControl(chkEmbed, rrCheck);
		
		/// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_MODE
		Control btnListView = GetItem(IDC_CHECK_LIST_VIEW);
		if( btnListView && btnListView.Visible )
		{
			RECT 	rrListView;
			GetClientRect(btnListView, rrListView);
			nWidth = RECT_WIDTH(rrListView);
			nHeight = RECT_HEIGHT(rrListView);
			
			rrListView.left = rrCheck.right + nGap ;
			///Army 08/03/09 FIX_LISTVIEW_AND_OKBUTTON_OVERLAP_IN_J_AND_G
			//rrListView.top = rrCheck.top - 1;
			rrListView.top = rrCheck.top;
			/// End FIX_LISTVIEW_AND_OKBUTTON_OVERLAP_IN_J_AND_G
			rrListView.right = rrListView.left + nWidth;
			rrListView.bottom = rrListView.top + nHeight;
			MoveControl(btnListView, rrListView);	
		}
		///end ADD_LIST_VIEW_MODE
		///End GET_EMBEDDED_GRAPHS
	}
	//---init dialog end
	
	/// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_MODE
	/*
	bool getGraphsInProjectTree(TreeNode tr, vector<string>& vsGraphs, vector<uint>& vnRows, bool bRecursive = false)
	{
		if(!tr.IsValid())
			return false;
		///Jasmine 01/23/07 IDENTIFY_LEVEL_BY_STOP_ATTRIB, a leaf can also be a folder, should get nLevel from STR_STOP_ATTRIB
		int nLevel;
		if(tr.GetNodeCount() < 1 && tr.GetAttribute(STR_STOP_ATTRIB, nLevel) && PTL_FOLDER < nLevel)//leaf
		///End IDENTIFY_LEVEL_BY_STOP_ATTRIB
		{
			string strName;
			///Jasmine 11/03/06 SHOULD_SHOW_SHORT_NAME
			//tr.GetAttribute(STR_NAME_ATTRIB, strName);
			tr.GetAttribute(STR_LABEL_ATTRIB, strName);
			///End SHOULD_SHOW_SHORT_NAME
			vsGraphs.Add(strName);
			int nRow = m_list.FindRow(strName);
			vnRows.Add(nRow);			
			//return true;
		}
		foreach(TreeNode cNode in tr.Children)
		{	///Jasmine 01/22/07 ADD_EMBEDED_GRAPHS_IN_WKS
			//should not change bRecursive directly
			bool bRecusiveSubNode = bRecursive;
			int nDisplay;
			if(cNode.GetAttribute(STR_DISPLAY_ATTRIB, nDisplay) && nDisplay == get_page_display_id(EXIST_WKS))//only check workbook
				bRecusiveSubNode = true;
			///End ADD_EMBEDED_GRAPHS_IN_WKS
			if(!cNode.IsValid() || (cNode.GetNodeCount() && !bRecusiveSubNode) )
				continue;
			getGraphsInProjectTree(cNode, vsGraphs, vnRows, bRecusiveSubNode);
		}
		return true;
	}
	*/
	///end ADD_LIST_VIEW_MODE
	
	//---setup page list
	int addPages(const vector<string>& vsAdded, bool bCheckOpen = false)
	{		
		getPages();
		
		int nAdded;
		int nRowStart = m_list.GetRows();
		int nRowOffset = m_list.GetRowOffset();			///Folger 04/03/07 ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER
		for(int ii = 0; ii < vsAdded.GetSize(); ii++)
		{
			//to check if the page have existed in the current list
			//bool bExist = false;
			bool bAdd = true;
			string strName = vsAdded[ii];
			if( m_vsPageList.GetSize()>0 )
			{
				if(-1 != m_vsPageList.Find(strName))//vsAdded[ii])) 
					//bExist = true;
					bAdd = false;
			}			
			if(bAdd && bCheckOpen)//!bExist)
			{
				//-------Folger 07/18/07 SHOW_BOTH_GRAPH_AND_LAYOUT_IN_TREE_PANEL
				//GraphPage gp(strName);
				//if(gp.GetShow() ==PAGE_HIDDEN || gp.GetShow() ==PAGE_MINIMIZED )
				GraphPageBase gpb(strName);
				if(gpb.GetShow() ==PAGE_HIDDEN || gpb.GetShow() ==PAGE_MINIMIZED )
				//-------End SHOW_BOTH_GRAPH_AND_LAYOUT_IN_TREE_PANEL
					bAdd = false;
			}
			// if not exist, add it
			if(bAdd)
			{
				///Folger 04/03/07 ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER
				m_list.SetRows(nRowStart + nAdded + 1 - nRowOffset);
				//m_list.SetRows(nRowStart + nAdded + 1);
				///End ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER
				m_list.SetCell(nRowStart + nAdded, COL_NAME, strName);//COL_INDEX, vsAdded[ii]);
				
				string strPath = getFullPathFromPageName(strName);
				m_list.SetCell(nRowStart + nAdded, COL_PATH, strPath);
				nAdded++;				
			}
		}
		return nAdded;
	}
	/// Iris 8/24/06 CONTROL_CHOOSE_ONLY_ONE_PAGE
	string getSelectedPage()
	{
		/// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_CHECKBOX
		/*
		int 		nSelRow = m_trFolder.GetSelectedRow();
		TreeNode 	trSel = tree_get_node(m_tree, nSelRow);
		vector<string> 	vsGraphs;
		vector<uint> 	vnRows;
		getGraphsInProjectTree(trSel, vsGraphs, vnRows, false);
		*/
		vector<string> 	vsGraphs;
		if( 0 == m_PageView.GetSelectedPages(vsGraphs) )
			return "";	
		///end ADD_LIST_VIEW_CHECKBOX
		
		string 		strPage;
		if(vsGraphs.GetSize()!=0)
			strPage = vsGraphs[0];
		return strPage;
	}
	///end CONTROL_CHOOSE_ONLY_ONE_PAGE
	
	void addSelected(bool bRecursive = false, bool bCheckOpen = false)
	{
		/// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_CHECKBOX
		/*
		vector<string> 	vsAdd;
		vector<uint> 	vnSelRows;
		m_trFolder.GetSelRows(vnSelRows);
		//get pages name from treenode
		for(int ii = 0; ii < vnSelRows.GetSize(); ii++)
		{
			int nSelRow = vnSelRows[ii];
			TreeNode trSel = tree_get_node(m_tree, nSelRow);
			vector<string> 	vsGraphs;
			vector<uint> 	vnRows;
			getGraphsInProjectTree(trSel, vsGraphs, vnRows, bRecursive);
			for(int nn = 0; nn < vsGraphs.GetSize(); nn++)
			{
				if(vsAdd.Find(vsGraphs[nn]) < 0) 				
					vsAdd.Add(vsGraphs[nn]);
			}
			//delete visited rows from vnSelRows
			if(vnRows.GetSize() > 0)
			{
				vector<uint> vnDel;
				vnDel= vnRows;
				int nLastRow = vnRows[vnRows.GetSize() - 1];
				if(bRecursive && nSelRow > -1 && nLastRow >= nSelRow)
					vnDel.Data(nSelRow, nLastRow);
				for(nn = 0; nn < vnDel.GetSize() && vnSelRows.GetSize() > 0; nn++)
				{
					vector<uint> vecIndex;
					vnSelRows.Find(vecIndex, vnDel[nn]);
					if(vecIndex.GetSize() > 0)
						vnSelRows.RemoveAt(vecIndex[0]);
				}
			}
		}
		//add to SelList
		if(addPages(vsAdd, bCheckOpen) && 0 < m_list.GetRows() - m_list.GetRowOffset())
			GetItem(IDOK).Enable = true;	///Jasmine 02/06/07 DISABLE_OK_BUTTON_IF_NO_SELECTION
		*/		
		vector<string> vsGraphs;
		m_PageView.GetSelectedPages(vsGraphs, bRecursive);
		
		// add to SelList
		if( addPages(vsGraphs, bCheckOpen) )
			/// Kenny 07/17/2009 QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
#ifdef __ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
			updateOKBtnStatus();
#else
			/// End QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
			GetItem(IDOK).Enable = true;
#endif	/// Kenny 07/17/2009 QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
		///end ADD_LIST_VIEW_CHECKBOX		
	}
	
	bool addPage(TreeNode tr, bool bRecursive = false, bool bCheckOpen = false)
	{
		if(tr.GetNodeCount() < 1)
		{
			string strName;
			///Jasmine 11/03/06 SHOULD_SHOW_SHORT_NAME
			//tr.GetAttribute(STR_NAME_ATTRIB, strName);
			tr.GetAttribute(STR_LABEL_ATTRIB, strName);
			///End SHOULD_SHOW_SHORT_NAME
			addPage(strName, bCheckOpen);
		}
		foreach(TreeNode cNode in tr.Children)
		{
			if(!cNode.IsValid() || (cNode.GetNodeCount() && !bRecursive) )
				continue;
			addPage(cNode, bRecursive, bCheckOpen);
		}
		return true;
	}
	
	int addPage(string strName, bool bCheckOpen = false)
	{
		//check exist
		if( m_vsPageList.GetSize() > 0 && -1 < m_vsPageList.Find(strName)) 
			return 0;
		
		if(bCheckOpen)
		{
			//-------Folger 07/18/07 SHOW_BOTH_GRAPH_AND_LAYOUT_IN_TREE_PANEL
			//GraphPage gp(strName);
			//if(gp.GetShow() ==PAGE_HIDDEN || gp.GetShow() ==PAGE_MINIMIZED )
			GraphPageBase gpb(strName);
			if(gpb.GetShow() ==PAGE_HIDDEN || gpb.GetShow() ==PAGE_MINIMIZED )
			//-------End SHOW_BOTH_GRAPH_AND_LAYOUT_IN_TREE_PANEL
				return -1;
		}
		string strPath = getFullPathFromPageName(strName);
		m_list.InsertRow();
		int nRow = m_list.GetRows();
		m_list.SetCell(nRow - 1, COL_NAME, strName);
		m_list.SetCell(nRow - 1, COL_PATH, strPath);
		m_vsPageList.Add(strName);
		
		return nRow;
	}
	
	//to check if have select one, if not, then select the first one
	void selectRow(int nRow = -1)
	{
		if( m_list.GetRows() <= 0 )
			return;
		
		while( nRow >= m_list.GetRows() )
			nRow--;
			
		if(nRow < 0)
			nRow = m_list.GetSelectedRow(); // get 1st if multiple selection, -1 if none selected
		if( nRow < 0 )
			nRow = 0;
		
		m_list.SelRow(nRow);		
	}
	
	void removeSelectedPages()
	{
		vector<uint> vnRows;
		if(!m_list.GetSelRows(vnRows))
			return;
		
		int nSelRow = m_list.GetSelectedRow();
		//for(int index = 0; index < vnRows.GetSize(); index++)		///Kevin 08/15/05 v8.0287 QA70-6323 FIX_REMOVE_SELECT_PAGE_BUG
		for(int index = vnRows.GetSize() - 1; index >= 0; index--) 
			m_list.DeleteRow(vnRows[index]);
		
		selectRow(nSelRow);
		getPages();
	}
	
	void removeAllPages()
	{
		m_list.SetRows(0);
	}
	
	// get all pages from list and save into m_vsPageList
	bool getPages()
	{
		m_vsPageList.SetSize(0);
		
		int nRows = m_list.GetRows();		
		if(nRows <= 0)
			return false;
		
		///Folger 04/03/07 ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER
		//for(int nRow = 0; nRow < nRows; nRow++)
		for(int nRow = m_list.GetRowOffset(); nRow < nRows; nRow++)
		///End ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER
		{
			string str = m_list.GetCell(nRow, COL_NAME);//COL_INDEX);
			m_vsPageList.Add(str);			
		}
		/// Iris 6/26/2009 QA80-13711 PREVIEW_SHOULD_SHOW_FIRST_IN_LIST_WHEN_DLG_OPEN
		//return true;
		return m_vsPageList.GetSize()>0;
		///end PREVIEW_SHOULD_SHOW_FIRST_IN_LIST_WHEN_DLG_OPEN
	}
	
	// get all pages list and return a string
	string getPageList()
	{
		string 			strPageList;
		if(m_vsPageList.GetSize() == 0)
			return strPageList;
		
		if(isFullPath(m_vsPageList[0]))
			for(int ii=0; ii<m_vsPageList.GetSize(); ii++)
				m_vsPageList[ii] = getPageNameFromFullPath(m_vsPageList[ii]);
			
		strPageList.SetTokens(m_vsPageList, STR_PAGE_LIST_SEPARATOR);
		
		return strPageList;
	}
	
	//reset page list
	void updatePageList(vector<string>& vsPages)
	{/*
		int nSelRow = m_list.GetSelectedRow();
		
		removeAllPages();		
	
		addPages(vsPages);
		
		selectRow(nSelRow);	*/	
	}
	
	bool showPagesFullPath(bool bFullPath)
	{
		getPages(); //get the current page list to m_vsPageList
		
		vector<string> vsPages(m_vsPageList.GetSize());
		for(int index=0; index<m_vsPageList.GetSize(); index++)
		{
			if(bFullPath)
				vsPages[index] = getFullPathFromPageName(m_vsPageList[index]);				
			else
				vsPages[index] = getPageNameFromFullPath(m_vsPageList[index]);
		}
		
		BeforeUpdate();
		updatePageList(vsPages);
		AfterUpdate();
		
		return true;
	}
	
	string getFullPathFromPageName(string strPage)
	{
		/// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_MODE
		/*
		string strPath;
		PageBase pg = Project.Pages(strPage);
		if( !pg )
			return strPath;
		///Jasmine 11/10/06 QA70-9112 GET_EMBEDDED_GRAPHS
		//strPath = pg.GetFolder().GetPath() + pg.GetName();
		TreeNode tr = m_tree.FindNodeByAttribute(STR_LABEL_ATTRIB, strPage);		
		if(tr)
			tr.GetAttribute(STR_PATH_ATTRIB, strPath);
		///End GET_EMBEDDED_GRAPHS
		return strPath;
		*/
		/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
		//if( VIEW_MODE_PE == m_nViewMode )
		if(  VIEW_MODE_PE == isListViewChecked() )
		///end FILTER_GRAPH_FUNCTION_SUPPORT
			return m_PageView.GetPEViewPointer()->GetFullPathFromPageName(strPage);
		else
		{
			Page pg(strPage);
			
			Worksheet wks;
			if( pg.GetEmbeddingInfo(wks) )
			{
				pg = wks.GetPage();
			}
			
			if(pg)
			{
				Folder fld = pg.GetFolder();
				return fld.GetPath();
			}
		}		
		return "";
		///end ADD_LIST_VIEW_MODE
	}
	
	string getPageNameFromFullPath(string strFullPath)
	{
		string 			strPage;
		vector<string> 	vsPage;
		if( strFullPath.GetTokens(vsPage, CHAR_FLD_SEPARATOR) <= 0 )
			return strPage;
		
		strPage = vsPage[vsPage.GetSize()-1];
		
		return strPage;
	}	
	///Jasmine 01/22/07 UNCOMMENT_FOR_DRAG_AND_DROP_NOT_READY
	/// Iris 8/24/06 SUPPORT_DROP_LIST_LIKE_XF_BUILDER
	void moveRowUp()
	{
		vector<uint> vnSels;
		if( !m_list.GetSelRows(vnSels))
			return;
		
		for(int index=0; index<vnSels.GetSize(); index++)
		{
			int nRow = vnSels[index];
			///Folger 04/03/07 ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER
			if(nRow<=1)
				return;
			//if(nRow<=0)
				//return;
			///End ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER
			
			string strTemp = m_list.GetCell(nRow-1, COL_NAME);
			m_list.SetCell(nRow-1, COL_NAME, m_list.GetCell(nRow, COL_NAME));
			m_list.SetCell(nRow, COL_NAME, strTemp);
			
			strTemp = m_list.GetCell(nRow-1, COL_PATH);
			m_list.SetCell(nRow-1, COL_PATH, m_list.GetCell(nRow, COL_PATH));
			m_list.SetCell(nRow, COL_PATH, strTemp);
			
			selectRow(nRow-1);
		}
	}
	
	void moveRowDown()
	{
		vector<uint> vnSels;
		if( !m_list.GetSelRows(vnSels))
			return;
		
		for(int index=0; index<vnSels.GetSize(); index++)
		{
			int nRow = vnSels[index];
			///Folger 04/03/07 ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER
			if(nRow<=0 || nRow>= m_list.GetRows()-1)
				return;
			//if(nRow<0 || nRow>= m_list.GetRows()-1)
				//return;
			///End ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER
			
			string strTemp = m_list.GetCell(nRow+1, COL_NAME);
			m_list.SetCell(nRow+1, COL_NAME, m_list.GetCell(nRow, COL_NAME));
			m_list.SetCell(nRow, COL_NAME, strTemp);
			
			strTemp = m_list.GetCell(nRow+1, COL_PATH);
			m_list.SetCell(nRow+1, COL_PATH, m_list.GetCell(nRow, COL_PATH));
			m_list.SetCell(nRow, COL_PATH, strTemp);
			
			selectRow(nRow+1);	
		}
	}
	///end SUPPORT_DROP_LIST_LIKE_XF_BUILDER
	///End UNCOMMENT_FOR_DRAG_AND_DROP_NOT_READY
	bool isFullPath(string strPageList)
	{
		if( -1 == strPageList.Find(CHAR_FLD_SEPARATOR))
			return false;
		return true;
	}
	
public:
	string GetPages(bool bIncludePath = false)
	{		
		return getPageList();		
	}
	//--- CPY 12/11/05 REMOVE_FO_CODE_FROM_PROJ_BROWER
	
	/// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_CHECKBOX
	/*
	void UpdateTreePane(bool bShowEmbedded = false)
	{
		m_trFolder.ClearAll();
		m_tree.Reset();
		string 		strStartPEpathTemp = m_bShowFolders? "" : m_strStartPEPath;
		//-------Folger 07/18/07 SHOW_BOTH_GRAPH_AND_LAYOUT_IN_TREE_PANEL
		//bool flag = get_project_tree(m_tree, PTL_PAGE, EXIST_GRAPH, 0, strStartPEpathTemp, bShowEmbedded);
		//-------Folger 07/19/07 CONTROL_BROWSE_PAGE_TYPE
		//int nPage2 = m_bShowLayout ? EXIST_LAYOUT : 0;
		//bool flag = get_project_tree(m_tree, PTL_PAGE, EXIST_GRAPH, nPage2, strStartPEpathTemp, bShowEmbedded);
		//bool flag = get_project_tree(m_tree, PTL_PAGE, m_nPageType, 0, strStartPEpathTemp, bShowEmbedded);		
		/// Iris 5/04/2009 QA80-13552 SUPPORT_OPTION_TO_SORT_PAGE_LIST_AND_FILTER_3D_PAGE
		ProjectTreeOptions stOptions;
		stOptions.bGetEmbeddedGraph = bShowEmbedded;
		stOptions.bSortPages = m_bSortPages;
		stOptions.bFilter3DGraph = m_bFilter3DGraph;
		bool flag = get_project_tree(m_tree, PTL_PAGE, m_nPageType, 0, strStartPEpathTemp, stOptions);
		///end SUPPORT_OPTION_TO_SORT_PAGE_LIST_AND_FILTER_3D_PAGE		
		//-------End CONTROL_BROWSE_PAGE_TYPE
		//-------End SHOW_BOTH_GRAPH_AND_LAYOUT_IN_TREE_PANEL
		///Folger 06/05/07 COMMENT_STR_EXCLUDE_PAGE
		//exclude specified treenode
		//if(!m_strExclude.IsEmpty())
		//{
			//// Iris 12/12/2006 8.0523 TO_EXCLUDE_MULTI_PAGES
			//
			/////Jasmine 11/03/06 SHOULD_SHOW_SHORT_NAME
			////TreeNode tr = m_tree.FindNodeByAttribute(STR_NAME_ATTRIB, m_strExclude);
			//TreeNode tr = m_tree.FindNodeByAttribute(STR_LABEL_ATTRIB, m_strExclude);
			/////End SHOULD_SHOW_SHORT_NAME
			//if(tr.IsValid())
				//tr.Remove();
			//
			//vector<string> 	vsExclude;
			//m_strExclude.GetTokens(vsExclude, '|');
			//for(int ii=0; ii<vsExclude.GetSize(); ii++)
			//{
				//TreeNode tr = m_tree.FindNodeByAttribute(STR_LABEL_ATTRIB, vsExclude[ii]);
				//if(tr.IsValid())
					//tr.Remove();
			//}
			/////end TO_EXCLUDE_MULTI_PAGES
		//}
		///End COMMENT_STR_EXCLUDE_PAGE
		flag = m_trFolder.AddTreeNodes(m_tree, ATRN_LOOP_MARDED_NODE_ONLY, STR_DISPLAY_ATTRIB);
		ShowMoreInfo(m_bLName, m_bCell);///Jasmine 11/17/06 SHOW_LNAME_AND_CELL
		///jasmine 10/24/06 SHOW_DEFAULT_FOLDER_PAGE
		int nRow;
		if(m_bShowFolders)
		{
			///Jasmine 11/03/06 FIND_NODE_BY_ATTRBUTE_ONLY_FIND_CHILDREN
			//TreeNode tr = m_tree.FindNodeByAttribute(STR_PATH_ATTRIB, m_strStartPEPath);
			TreeNode tr = m_tree;
			string str;
			m_tree.GetAttribute(STR_PATH_ATTRIB, str);
			if(m_strStartPEPath.CompareNoCase(str))
				tr = m_tree.FindNodeByAttribute(STR_PATH_ATTRIB, m_strStartPEPath);
			///End FIND_NODE_BY_ATTRBUTE_ONLY_FIND_CHILDREN
			string strLabel;
			///Jasmine 11/21/06 FIX_TREE_PANE_FAIL_TO_DISPLAY
			for( ; tr.FirstNode.IsValid(); tr = tr.FirstNode)
				;
			if(tr.IsValid())
				tr.GetAttribute(STR_LABEL_ATTRIB, strLabel);
			nRow = m_trFolder.FindRow(strLabel);
			//if(tr.GetNodeCount())
				//nRow++;
			///End FIX_TREE_PANE_FAIL_TO_DISPLAY
		}
		m_trFolder.SelRow(nRow);		
		///End SHOW_DEFAULT_FOLDER_PAGE
	}	
	///End GET_EMBEDDED_GRAPHS
	///Jasmine 11/17/06 SHOW_LNAME_AND_CELL
	void ShowMoreInfo(bool bLongName = false, bool bCell = false)
	{
		for(int nRow = 0; ; nRow++)
		{
			string strLabel, strSName, strLName, strCell;
			TreeNode trRow = tree_get_node(m_tree, nRow);
			if(!trRow.IsValid())
				break;
			int nDisplay, nLevel;
			trRow.GetAttribute(STR_DISPLAY_ATTRIB, nDisplay);
			trRow.GetAttribute(STR_STOP_ATTRIB, nLevel);
			if(PTL_PAGE != nLevel)//LName is for page only
				continue;
			trRow.GetAttribute(STR_LABEL_ATTRIB, strSName);
			strLabel = strSName;
			if(bLongName)
			{
				trRow.GetAttribute(STR_NAME_ATTRIB, strLName);
				strLabel += " - "+ strLName;
			}
			if(bCell && nDisplay == IDR_GRAPHTYPE_V8)//bCell is for Embedded GraphPage only
			{
				//-------Folger 07/18/07 SHOW_BOTH_GRAPH_AND_LAYOUT_IN_TREE_PANEL
				//GraphPage gp(strSName);
				//if(gp.GetEmbeddingInfo())
				GraphPageBase gpb(strSName);
				if(gpb.GetEmbeddingInfo())
				//-------Folger 07/18/07 SHOW_BOTH_GRAPH_AND_LAYOUT_IN_TREE_PANEL
					;//doing...
			}
			m_trFolder.SetCell(nRow, 0, strLabel);
		}
	}
	///End SHOW_LNAME_AND_CELL
	*/
	///end ADD_LIST_VIEW_CHECKBOX
	
private:
	bool loadGraphPageThumbnail(string &strPageName)
	{
		GraphPageBase 		pgb = Project.Pages(strPageName);
		
		PictureHolder 		pictHolder;
		if (pgb.IsValid())
			page_get_picture(pgb, pictHolder, "EMF", 72, false);
		else
		{
			// Show "NONE Preview" if page is invalid
			string strPath = STR_PREVIEW_GRAPH_TEMPLATE + STR_PICT_NO_PREVIEW + ".emf";	 
			if(strPath.IsFile())
	  		{
		   		m_pcPrev.DrawMode = PCDM_STRETCH_FILL;
		   		HENHMETAFILE henhmf1 = load_enhanced_metafile(strPath);
				return m_pcPrev.SetEnhMetaFile(henhmf1);
			}
		}
		
    	m_pcPrev.Visible = false;
    	if(pictHolder)
    	{
	    	m_pcPrev.SetPicture(pictHolder);
	    	m_pcPrev.KeepAspectRatio = true;
	    	m_pcPrev.Visible = true;
	    	return true;
    	}
    	return false;
	}	
	/// Kenny 07/17/2009 QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
#ifdef __ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
	void updateOKBtnStatus(bool bCheckRowCountOnly = true)
	{
		BOOL bShouldBeEnable = FALSE;

		if ( m_bMultiplePages )
		{
			int nListRows = m_list.GetRows() - m_list.GetRowOffset();

			bool bGraphChanged = true;
			if ( !bCheckRowCountOnly )
			{
				string strCurrent;
				strCurrent.SetTokens(m_vsPageList);
				bGraphChanged = m_strDiff.IsEmpty() || strCurrent.CompareNoCase(m_strDiff) != 0;
			}

			bShouldBeEnable = nListRows > 0 && bGraphChanged;
		}
		else
		{
			if ( isListViewChecked() == VIEW_MODE_LIST )
			{
				bShouldBeEnable = !m_PageView.GetSelectedPage().IsEmpty();
			}
			else
			{
				PEView* pPEView = m_PageView.GetPEViewPointer();
				ASSERT(NULL != pPEView);
				bShouldBeEnable = ( pPEView && pPEView->IsSpecifiedPageTypeSelected(EXIST_GRAPH) );
			}
		}

		GetItem(IDOK).Enable = bShouldBeEnable;
	}
#endif // __ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
	/// End QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
private:
	///Folger 04/03/07 ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER
	TreeEditControl 	m_list;
	//GridListControl		m_list;
	///End ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER
	
	/// Iris 6/11/2009 QA80-13771 ADD_LIST_VIEW_CHECKBOX
	//GridTreeControl 	m_trFolder;
	PageViewManager		m_PageView;
	//int				m_nViewMode; /// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
	///end ADD_LIST_VIEW_CHECKBOX	
	
	Tree				m_tree;
	PictureControl 		m_pcPrev;

	vector<string>		m_vsPageList;
	bool				m_bCloseOnDBClick;	///Jasmine 12/19/06 ADD_DBCLICK_ON_TREE_PANEL
	string				m_strDlgTitle;
	string				m_strRegisterName;	///Jasmine 04/28/10 DLG_HAS_DIFF_SHAPE_AND_SAVE_DIFF_SIZE
	vector<int>		    m_vnPageTypes;
	string				m_strStartPEPath;
	string				m_strSel;	
	bool				m_bShowFolders;
	bool				m_bMultiplePages;
	bool				m_bLName;
	bool				m_bEmbed;
	bool				m_bIncludeShortcut;	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	bool				m_bCell;
	string				m_strDiff;				///Folger 04/03/07 ADD_GRAG_AND_DROP_TO_GRAPH_BROWSER
	bool				m_bEnableEmbed;
	int					m_nPageType;
	
	/// Iris 5/04/2009 QA80-13552 SUPPORT_OPTION_TO_SORT_PAGE_LIST_AND_FILTER_3D_PAGE
	bool				m_bSortPages;
	bool				m_bFilter3DGraph;
	///end SUPPORT_OPTION_TO_SORT_PAGE_LIST_AND_FILTER_3D_PAGE
	string				m_strFilterFuncName;  /// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
};
/////////////////PagePreviewListDlg Class End


/// Iris 8/23/06 QA80-7729 GRAPH_BRWOSER_BUTTON_IN_GETN
/////Jasmine 11/25/05 QA70-8352 v8.0340 OPEN_PAGE_PREVIEW_LIST_DLG
//BOOL OpenPagePreviewListDlg(string strExclude, vector<string>& vsPages, HWND hWnd)
//{
	//vector<int> 	vnPageTypes = {EXIST_GRAPH};
	//string			strPages;
	//strPages.SetTokens(vsPages, STR_PAGE_LIST_SEPARATOR);
	//
	//PagePreviewListDlg myDlg(vnPageTypes, strPages, true, NULL, NULL, true, strExclude);
	//
	//int 		nRet = myDlg.DoModalEx(hWnd);
	//if(IDCANCEL == nRet)
		//return false;
	//
	//strPages = myDlg.GetPages();
	//strPages.GetTokens(vsPages, STR_PAGE_LIST_SEPARATOR);
	//
	//return true;
//}
/////End OPEN_PAGE_PREVIEW_LIST_DLG


// if bShowFolders = false, then only pick from specified folder, if true, then can switch to other folders
///Folger 06/05/07 COMMENT_STR_EXCLUDE_PAGE
//BOOL PagePreviewListGraph(HWND hWndParent, string& strGraphs, bool bMultilePages = true, LPCSTR lpcszStartPEpath = NULL, bool bShowFolders = true, LPCSTR lpcszExcludeGraph = NULL, bool bEnableEmbed = true)
//------Folger 07/18/07 CLEAN_UP_CONTROL_BITS_INTO_DWORD_FOR_GRAPH_BROWSER
//BOOL PagePreviewListGraph(HWND hWndParent, string& strGraphs, bool bMultilePages = true, LPCSTR lpcszStartPEpath = NULL, bool bShowFolders = true, bool bEnableEmbed = true)
//-------Folger 07/19/07 CONTROL_BROWSE_PAGE_TYPE
//BOOL PagePreviewListGraph(HWND hWndParent, string& strGraphs, LPCSTR lpcszStartPEpath = NULL, DWORD dwCtrl = SELECT_MULTIPLE_PAGES | SHOW_FOLDERS | ENABLE_EMBEDED)
/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
//BOOL PagePreviewListGraph(HWND hWndParent, string& strGraphs, LPCSTR lpcszStartPEpath = NULL, DWORD dwCtrl = SELECT_MULTIPLE_PAGES | SHOW_FOLDERS | ENABLE_EMBEDED, int nPageType = EXIST_GRAPH)
BOOL PagePreviewListGraph(HWND hWndParent, string& strGraphs, LPCSTR lpcszStartPEpath = NULL, DWORD dwCtrl = SELECT_MULTIPLE_PAGES | SHOW_FOLDERS | ENABLE_EMBEDED, int nPageType = EXIST_GRAPH, LPCSTR lpcszFilterFuncName = NULL)
///end FILTER_GRAPH_FUNCTION_SUPPORT
//-------End CONTROL_BROWSE_PAGE_TYPE
//------End CLEAN_UP_CONTROL_BITS_INTO_DWORD_FOR_GRAPH_BROWSER
{
	vector<string>	vsPages;
	vector<int> 	vnPageTypes = {EXIST_GRAPH};
	
//	PagePreviewListDlg 	myDlg(vnPageTypes, strGraphs, bMultilePages, NULL, lpcszStartPEpath, bShowFolders, lpcszExcludeGraph, bEnableEmbed);
	//------Folger 07/18/07 CLEAN_UP_CONTROL_BITS_INTO_DWORD_FOR_GRAPH_BROWSER
	//PagePreviewListDlg 	myDlg(vnPageTypes, strGraphs, bMultilePages, NULL, lpcszStartPEpath, bShowFolders, bEnableEmbed);
	//-------Folger 07/19/07 CONTROL_BROWSE_PAGE_TYPE
	//PagePreviewListDlg 	myDlg(vnPageTypes, strGraphs, NULL, lpcszStartPEpath, dwCtrl);
	/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
	//PagePreviewListDlg 	myDlg(vnPageTypes, strGraphs, NULL, lpcszStartPEpath, dwCtrl, nPageType);	
	PagePreviewListDlg 	myDlg(vnPageTypes, strGraphs, NULL, lpcszStartPEpath, dwCtrl, nPageType, lpcszFilterFuncName);
	///end FILTER_GRAPH_FUNCTION_SUPPORT
	//-------End CONTROL_BROWSE_PAGE_TYPE
	//------End CLEAN_UP_CONTROL_BITS_INTO_DWORD_FOR_GRAPH_BROWSER
///End COMMENT_STR_EXCLUDE_PAGE
	///Jasmine 10/26/06 KEEP_DLG_MODEL
	//int nRet = myDlg.DoModalEx(hWndParent);
	Window winExDlg = myDlg.GetWindow();
	if(winExDlg)
	{
		out_str("Dialog already open");
		return false;
	}
	Window winNewDlg(hWndParent);
	HWND hWnd = GetWindow();
	if(winNewDlg)
		hWnd = hWndParent;
	int nRet = myDlg.DoModalEx(hWnd);
	///Folger 05/22/07 FIX_BUG_ON_SINGLE_SELECTION
	///Jasmine 12/19/06 ADD_DBCLICK_ON_TREE_PANEL
	//if(IDCANCEL == nRet/* && strGraphs.IsEmpty()*/)
		//return FALSE;
	///End ADD_DBCLICK_ON_TREE_PANEL
	string strPages = myDlg.GetPages();
	if (strPages.IsEmpty())
		return FALSE;
	///End FIX_BUG_ON_SINGLE_SELECTION
	strGraphs = strPages;
	return TRUE;
	
}
///end GRAPH_BRWOSER_BUTTON_IN_GETN


